<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? htmlspecialchars($pageTitle) . ' - ' : ''; ?><?php echo get_setting('site_title', 'OAB Gaspar'); ?></title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="top-bar bg-primary text-white py-2">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <small>
                        <i class="bi bi-telephone"></i> <?php echo get_setting('contact_phone', '(00) 0000-0000'); ?>
                        <i class="bi bi-envelope ms-3"></i> <?php echo get_setting('contact_email', 'contato@site.com'); ?>
                    </small>
                </div>
                <div class="col-md-6 text-end">
                    <a href="<?php echo get_setting('instagram_url', '#'); ?>" target="_blank" class="text-white text-decoration-none">
                        <i class="bi bi-instagram"></i> Instagram
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <header class="bg-white shadow-sm">
        <div class="container py-3">
            <div class="row align-items-center">
                <div class="col-md-3">
                    <a href="index.php" class="text-decoration-none">
                        <h2 class="mb-0 text-primary fw-bold">
                            <i class="bi bi-building"></i> <?php echo get_setting('site_title', 'OAB Gaspar'); ?>
                        </h2>
                    </a>
                </div>

                <div class="col-md-9">
                    <nav class="navbar navbar-expand-lg">
                        <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse" 
                                data-bs-target="#mainNav">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        <div class="collapse navbar-collapse" id="mainNav">
                            <ul class="navbar-nav ms-auto">
                                <li class="nav-item">
                                    <a class="nav-link" href="index.php">INÍCIO</a>
                                </li>

                                <?php
                                try {
                                    $pageModel = new Page();
                                    $menu_items = $pageModel->getAllForMenu();

                                    $menu_tree = [];
                                    $children_of = [];

                                    foreach ($menu_items as $item) {
                                        if ($item['parent_id'] === null) {
                                            $menu_tree[$item['id']] = $item;
                                            $menu_tree[$item['id']]['children'] = [];
                                        } else {
                                            $children_of[$item['parent_id']][] = $item;
                                        }
                                    }

                                    foreach ($children_of as $parent_id => $children) {
                                        if (isset($menu_tree[$parent_id])) {
                                            $menu_tree[$parent_id]['children'] = $children;
                                        }
                                    }

                                    foreach ($menu_tree as $item) {
                                        if (empty($item['children'])) {
                                            echo '<li class="nav-item">';
                                            echo '<a class="nav-link" href="page.php?slug=' . htmlspecialchars($item['slug']) . '">' . strtoupper(htmlspecialchars($item['title'])) . '</a>';
                                            echo '</li>';
                                        } else {
                                            // ===================================================================
                                            // LÓGICA CORRIGIDA AQUI
                                            // ===================================================================
                                            echo '<li class="nav-item dropdown">';
                                            // O link principal agora só abre o dropdown, não navega para uma página
                                            echo '<a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">' . strtoupper(htmlspecialchars($item['title'])) . '</a>';
                                            echo '<ul class="dropdown-menu">';
                                            
                                            // A linha que criava o link para a página pai foi REMOVIDA.
                                            
                                            // Adiciona apenas os links das páginas "filhas"
                                            foreach ($item['children'] as $child) {
                                                echo '<li><a class="dropdown-item" href="page.php?slug=' . htmlspecialchars($child['slug']) . '">' . htmlspecialchars($child['title']) . '</a></li>';
                                            }
                                            echo '</ul>';
                                            echo '</li>';
                                            // ===================================================================
                                        }
                                    }
                                } catch (Exception $e) {
                                    if (defined('DEBUG_MODE') && DEBUG_MODE) {
                                        echo '<li class="nav-item"><span class="nav-link text-danger">Erro ao carregar o menu</span></li>';
                                    }
                                }
                                ?>
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </header>