<?php
if (!defined('ADMIN_ACCESS')) {
    header("Location: login.php");
    exit;
}
include 'admin_header.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Gerenciamento de Notícias</h1>
        <a href="posts.php?action=create" class="btn btn-primary"><i class="fas fa-plus me-2"></i> Nova Notícia</a>
    </div>

    <?php if (!empty($message)): ?>
        <div class="alert alert-info" role="alert">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>ID</th>
                <th>Título</th>
                <th>Categoria</th>
                <th>Autor</th>
                <th>Status</th>
                <th>Data Criação</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($posts)): ?>
                <?php foreach ($posts as $post): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($post['id']); ?></td>
                        <td><?php echo htmlspecialchars($post['title']); ?></td>
                        <td><?php echo htmlspecialchars($post['category_name'] ?? 'N/A'); ?></td>
                        <td><?php echo htmlspecialchars($post['author_name'] ?? 'Desconhecido'); ?></td>
                        <td>
                            <span class="badge <?php echo ($post['status'] == 'published') ? 'bg-success' : 'bg-warning text-dark'; ?>">
                                <?php echo ucfirst(htmlspecialchars($post['status'])); ?>
                            </span>
                        </td>
                        <td><?php echo date('d/m/Y H:i', strtotime($post['created_at'])); ?></td>
                        <td>
                            <a href="posts.php?action=edit&id=<?php echo $post['id']; ?>" class="btn btn-sm btn-warning me-2" title="Editar"><i class="fas fa-edit"></i></a>
                            <a href="posts.php?action=delete&id=<?php echo $post['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza que deseja excluir esta notícia?')" title="Excluir"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" class="text-center">Nenhuma notícia encontrada.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include 'admin_footer.php'; ?>
