<?php
if (!defined('ADMIN_ACCESS')) {
    header("Location: login.php");
    exit;
}
include 'admin_header.php';

$is_edit = isset($post);
$form_title = $is_edit ? 'Editar Notícia' : 'Criar Nova Notícia';
?>

<div class="container-fluid">
    <h1><?php echo $form_title; ?></h1>

    <?php if (!empty($message)): ?>
        <div class="alert alert-danger" role="alert">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="posts.php?action=save">
        <?php if ($is_edit): ?>
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($post['id']); ?>">
        <?php endif; ?>

        <div class="mb-3">
            <label for="title" class="form-label">Título</label>
            <input type="text" class="form-control" id="title" name="title" value="<?php echo $is_edit ? htmlspecialchars($post['title']) : ''; ?>" required>
        </div>

        <div class="mb-3">
            <label for="category_id" class="form-label">Categoria</label>
            <select class="form-select" id="category_id" name="category_id" required>
                <option value="">Selecione uma Categoria</option>
                <?php foreach ($categories as $category): ?>
                    <option value="<?php echo htmlspecialchars($category['id']); ?>"
                        <?php echo ($is_edit && $post['category_id'] == $category['id']) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($category['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="excerpt" class="form-label">Resumo (Excerpt)</label>
            <textarea class="form-control" id="excerpt" name="excerpt" rows="3"><?php echo $is_edit ? htmlspecialchars($post['excerpt']) : ''; ?></textarea>
            <div class="form-text">Um breve resumo da notícia para a listagem.</div>
        </div>

        <div class="mb-3">
            <label for="content" class="form-label">Conteúdo</label>
            <textarea class="form-control" id="content" name="content" rows="15"><?php echo $is_edit ? htmlspecialchars($post['content']) : ''; ?></textarea>
        </div>

        <div class="mb-3">
            <label for="image" class="form-label">URL da Imagem de Destaque</label>
            <input type="url" class="form-control" id="image" name="image" value="<?php echo $is_edit ? htmlspecialchars($post['image']) : ''; ?>">
            <div class="form-text">URL completa da imagem que será usada como destaque.</div>
        </div>

        <div class="mb-3">
            <label for="status" class="form-label">Status</label>
            <select class="form-select" id="status" name="status" required>
                <option value="draft" <?php echo ($is_edit && $post['status'] == 'draft') ? 'selected' : ''; ?>>Rascunho</option>
                <option value="published" <?php echo ($is_edit && $post['status'] == 'published') ? 'selected' : ''; ?>>Publicado</option>
            </select>
        </div>

        <button type="submit" class="btn btn-primary"><?php echo $is_edit ? 'Salvar Alterações' : 'Criar Notícia'; ?></button>
        <a href="posts.php" class="btn btn-secondary">Cancelar</a>
    </form>
</div>

<!-- TinyMCE 6 CDN com sua API Key -->
<script src="https://cdn.tiny.cloud/1/h8apq7gn7djttwhj1v86hxx3886vahl4omj06i1gtgh760zz/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

<script>
  tinymce.init({
    selector: '#content', // O seletor do seu textarea

    // Lista de plugins (incluindo os premium do seu trial)
    plugins: [
      'anchor', 'autolink', 'charmap', 'codesample', 'emoticons', 'link', 'lists', 'media', 'searchreplace', 'table', 'visualblocks', 'wordcount',
      'checklist', 'mediaembed', 'casechange', 'formatpainter', 'pageembed', 'a11ychecker', 'tinymcespellchecker', 'permanentpen', 'powerpaste', 'advtable', 'advcode', 'advtemplate', 'importword', 'exportword', 'exportpdf'
    ],

    // Configuração da barra de ferramentas
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikrough | link media table | spellcheckdialog a11ycheck | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
    
    // Configurações adicionais para uma melhor experiência
    height: 650, // Aumenta a altura do editor
    menubar: 'file edit view insert format tools table help', // Adiciona o menu superior
    content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }', // Estilo do conteúdo dentro do editor
    
    // O PowerPaste é ativado automaticamente com o plugin
    powerpaste_allow_local_images: true,
    powerpaste_word_import: 'prompt',
    powerpaste_html_import: 'prompt',
  });
</script>

<?php include 'admin_footer.php'; ?>
