<?php
if (!defined('ADMIN_ACCESS')) {
    header("Location: login.php");
    exit;
}
include 'admin_header.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Gerenciamento de Páginas</h1>
        <a href="pages.php?action=create" class="btn btn-primary"><i class="fas fa-plus me-2"></i> Nova Página</a>
    </div>

    <?php if (!empty($message)): ?>
        <div class="alert alert-info" role="alert">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>ID</th>
                <th>Título</th>
                <th>Slug</th>
                <th>Status</th>
                <th>Ordem Menu</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($pages)): ?>
                <?php foreach ($pages as $page): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($page['id']); ?></td>
                        <td><?php echo htmlspecialchars($page['title']); ?></td>
                        <td><?php echo htmlspecialchars($page['slug']); ?></td>
                        <td>
                            <span class="badge <?php echo ($page['status'] == 'published') ? 'bg-success' : 'bg-warning text-dark'; ?>">
                                <?php echo ucfirst(htmlspecialchars($page['status'])); ?>
                            </span>
                        </td>
                        <td><?php echo htmlspecialchars($page['menu_order']); ?></td>
                        <td>
                            <a href="pages.php?action=edit&id=<?php echo $page['id']; ?>" class="btn btn-sm btn-warning me-2" title="Editar"><i class="fas fa-edit"></i></a>
                            <a href="pages.php?action=delete&id=<?php echo $page['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza que deseja excluir esta página?')" title="Excluir"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" class="text-center">Nenhuma página encontrada.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include 'admin_footer.php'; ?>
