<?php
if (!defined('ADMIN_ACCESS')) {
    header("Location: login.php");
    exit;
}
include 'admin_header.php';

$is_edit = isset($page);
$form_title = $is_edit ? 'Editar Página' : 'Criar Nova Página';
?>

<div class="container-fluid">
    <h1><?php echo $form_title; ?></h1>

    <?php if (!empty($message)): ?>
        <div class="alert alert-danger" role="alert">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="pages.php?action=save">
        <?php if ($is_edit): ?>
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($page['id']); ?>">
        <?php endif; ?>

        <div class="mb-3">
            <label for="title" class="form-label">Título</label>
            <input type="text" class="form-control" id="title" name="title" value="<?php echo $is_edit ? htmlspecialchars($page['title']) : ''; ?>" required>
        </div>

        <div class="mb-3">
            <label for="content" class="form-label">Conteúdo</label>
            <textarea class="form-control" id="content" name="content" rows="15"><?php echo $is_edit ? htmlspecialchars($page['content']) : ''; ?></textarea>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" id="status" name="status" required>
                    <option value="draft" <?php echo ($is_edit && $page['status'] == 'draft') ? 'selected' : ''; ?>>Rascunho</option>
                    <option value="published" <?php echo ($is_edit && $page['status'] == 'published') ? 'selected' : ''; ?>>Publicado</option>
                </select>
            </div>

            <div class="col-md-4 mb-3">
                <label for="parent_id" class="form-label">Página Pai (Subpágina)</label>
                <select class="form-select" id="parent_id" name="parent_id">
                    <option value="">Nenhuma (Página Principal)</option>
                    <?php foreach ($all_pages as $p): ?>
                        <?php if (!$is_edit || $p['id'] != $page['id']): // Não pode ser pai de si mesma ?>
                            <option value="<?php echo htmlspecialchars($p['id']); ?>"
                                <?php echo ($is_edit && $page['parent_id'] == $p['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($p['title']); ?>
                            </option>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-4 mb-3">
                <label for="menu_order" class="form-label">Ordem no Menu</label>
                <input type="number" class="form-control" id="menu_order" name="menu_order" value="<?php echo $is_edit ? htmlspecialchars($page['menu_order']) : '0'; ?>">
                <div class="form-text">Número para ordenar a página no menu.</div>
            </div>
        </div>

        <button type="submit" class="btn btn-primary"><?php echo $is_edit ? 'Salvar Alterações' : 'Criar Página'; ?></button>
        <a href="pages.php" class="btn btn-secondary">Cancelar</a>
    </form>
</div>

<!-- TinyMCE 6 CDN com sua API Key -->
<script src="https://cdn.tiny.cloud/1/h8apq7gn7djttwhj1v86hxx3886vahl4omj06i1gtgh760zz/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

<script>
  tinymce.init({
    selector: '#content', // O seletor do seu textarea

    // Lista de plugins (incluindo os premium do seu trial)
    plugins: [
      'anchor', 'autolink', 'charmap', 'codesample', 'emoticons', 'link', 'lists', 'media', 'searchreplace', 'table', 'visualblocks', 'wordcount',
      'checklist', 'mediaembed', 'casechange', 'formatpainter', 'pageembed', 'a11ychecker', 'tinymcespellchecker', 'permanentpen', 'powerpaste', 'advtable', 'advcode', 'advtemplate', 'importword', 'exportword', 'exportpdf'
    ],

    // Configuração da barra de ferramentas
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikrough | link media table | spellcheckdialog a11ycheck | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
    
    // Configurações adicionais para uma melhor experiência
    height: 650, // Aumenta a altura do editor
    menubar: 'file edit view insert format tools table help', // Adiciona o menu superior
    content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }', // Estilo do conteúdo dentro do editor
    
    // O PowerPaste é ativado automaticamente com o plugin
    powerpaste_allow_local_images: true,
    powerpaste_word_import: 'prompt',
    powerpaste_html_import: 'prompt',
  });
</script>

<?php include 'admin_footer.php'; ?>
