<?php
if (!defined('ADMIN_ACCESS')) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Painel Administrativo'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        .sidebar {
            height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            background-color: #343a40;
            padding-top: 20px;
            color: white;
        }
        .sidebar a {
            color: #adb5bd;
            padding: 10px 15px;
            text-decoration: none;
            display: block;
        }
        .sidebar a:hover {
            background-color: #495057;
            color: white;
        }
        .content {
            margin-left: 250px;
            padding: 20px;
        }
        .sidebar .active {
            background-color: #0d6efd;
            color: white;
        }
    </style>
</head>
<body>

<div class="sidebar">
    <h3 class="text-center mb-4 text-white">OAB Admin</h3>
    <ul class="nav flex-column">
        <li class="nav-item">
            <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'index.php') ? 'active' : ''; ?>" href="index.php">
                <i class="fas fa-tachometer-alt me-2"></i> Dashboard
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'posts.php') ? 'active' : ''; ?>" href="posts.php">
                <i class="fas fa-newspaper me-2"></i> Notícias
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'pages.php') ? 'active' : ''; ?>" href="pages.php">
                <i class="fas fa-file-alt me-2"></i> Páginas
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="logout.php">
                <i class="fas fa-sign-out-alt me-2"></i> Sair
            </a>
        </li>
    </ul>
</div>

<div class="content">
    <nav class="navbar navbar-light bg-light mb-4">
        <div class="container-fluid">
            <span class="navbar-text">
                Bem-vindo, <?php echo $_SESSION['username'] ?? 'Admin'; ?>!
            </span>
        </div>
    </nav>
