<?php
/**
 * Página de Post Individual
 */

require_once __DIR__ . '/../config/config.php';

$postModel = new Post();
$commentModel = new Comment();

$slug = $_GET['slug'] ?? '';
$post = $postModel->getBySlug($slug);

if (!$post) {
    header('HTTP/1.0 404 Not Found');
    include __DIR__ . '/../views/404.php';
    exit;
}

$postModel->incrementViews($post['id']);

$comments = $commentModel->getByPost($post['id']);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_comment'])) {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $content = trim($_POST['content'] ?? '');
    
    $errors = [];
    
    if (empty($name)) $errors[] = 'Nome é obrigatório';
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Email válido é obrigatório';
    if (empty($content)) $errors[] = 'Comentário é obrigatório';
    
    if (empty($errors)) {
        $commentData = [
            'post_id' => $post['id'],
            'author_name' => $name,
            'author_email' => $email,
            'content' => $content,
            'status' => 'pending'
        ];
        
        if ($commentModel->create($commentData)) {
            $success = 'Comentário enviado! Aguardando moderação.';
        } else {
            $errors[] = 'Erro ao enviar comentário';
        }
    }
}

$pageTitle = $post['title'];
include __DIR__ . '/../views/header.php';
?>

<main class="container py-4">
    <article class="post-single">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Início</a></li>
                <?php if ($post['category_name']): ?>
                    <li class="breadcrumb-item">
                        <a href="category.php?slug=<?php echo htmlspecialchars($post['category_slug']); ?>">
                            <?php echo htmlspecialchars($post['category_name']); ?>
                        </a>
                    </li>
                <?php endif; ?>
                <li class="breadcrumb-item active"><?php echo htmlspecialchars($post['title']); ?></li>
            </ol>
        </nav>
        
        <header class="mb-4">
            <?php if ($post['category_name']): ?>
                <span class="badge mb-2" 
                      style="background-color: <?php echo htmlspecialchars($post['category_color']); ?>;">
                    <?php echo htmlspecialchars($post['category_name']); ?>
                </span>
            <?php endif; ?>
            
            <h1 class="display-5 fw-bold"><?php echo htmlspecialchars($post['title']); ?></h1>
            
            <div class="text-muted small mt-2">
                <i class="bi bi-person"></i> <?php echo htmlspecialchars($post['author_name']); ?>
                <i class="bi bi-calendar ms-3"></i> <?php echo date('d/m/Y H:i', strtotime($post['published_at'])); ?>
                <i class="bi bi-eye ms-3"></i> <?php echo $post['views']; ?> visualizações
                <i class="bi bi-chat ms-3"></i> <?php echo $post['comments_count']; ?> comentários
            </div>
        </header>
        
        <?php if ($post['image']): ?>
            <img src="<?php echo htmlspecialchars($post['image']); ?>" 
                 class="img-fluid rounded mb-4" 
                 alt="<?php echo htmlspecialchars($post['title']); ?>">
        <?php endif; ?>
        
        <div class="post-content">
            <?php echo $post['content']; ?>
        </div>
        
        <hr class="my-5">
        
        <section class="comments-section">
            <h3 class="mb-4">
                <i class="bi bi-chat-left-text"></i> 
                Comentários (<?php echo count($comments); ?>)
            </h3>
            
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title">Deixe seu comentário</h5>
                    
                    <?php if (isset($success)): ?>
                        <div class="alert alert-success"><?php echo $success; ?></div>
                    <?php endif; ?>
                    
                    <?php if (!empty($errors)): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php foreach ($errors as $error): ?>
                                    <li><?php echo htmlspecialchars($error); ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <form method="POST">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="name" class="form-label">Nome *</label>
                                <input type="text" class="form-control" id="name" name="name" 
                                       value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label for="email" class="form-label">Email *</label>
                                <input type="email" class="form-control" id="email" name="email" 
                                       value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="content" class="form-label">Comentário *</label>
                            <textarea class="form-control" id="content" name="content" rows="4" required><?php echo htmlspecialchars($_POST['content'] ?? ''); ?></textarea>
                        </div>
                        <button type="submit" name="submit_comment" class="btn btn-primary">
                            <i class="bi bi-send"></i> Enviar Comentário
                        </button>
                    </form>
                </div>
            </div>
            
            <?php if (empty($comments)): ?>
                <p class="text-muted">Nenhum comentário ainda. Seja o primeiro a comentar!</p>
            <?php else: ?>
                <?php foreach ($comments as $comment): ?>
                    <div class="card mb-3">
                        <div class="card-body">
                            <h6 class="card-subtitle mb-2">
                                <i class="bi bi-person-circle"></i> 
                                <?php echo htmlspecialchars($comment['author_name']); ?>
                            </h6>
                            <p class="card-text"><?php echo nl2br(htmlspecialchars($comment['content'])); ?></p>
                            <small class="text-muted">
                                <i class="bi bi-clock"></i> 
                                <?php echo date('d/m/Y H:i', strtotime($comment['created_at'])); ?>
                            </small>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </section>
    </article>
</main>

<?php include __DIR__ . '/../views/footer.php'; ?>
