<?php
/**
 * Página Estática
 */

require_once __DIR__ . '/../config/config.php';

$pageModel = new Page();

$slug = $_GET['slug'] ?? '';
$page = $pageModel->getBySlug($slug);

if (!$page) {
    header('HTTP/1.0 404 Not Found');
    include __DIR__ . '/../views/404.php';
    exit;
}

$pageTitle = $page['title'];
include __DIR__ . '/../views/header.php';
?>

<main class="container py-4">
    <article>
        <h1 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page['title']); ?></h1>
        
        <div class="page-content">
            <?php echo $page['content']; ?>
        </div>
    </article>
</main>

<?php include __DIR__ . '/../views/footer.php'; ?>
