<?php
/**
 * Página Principal
 * OAB Gaspar Clone - Versão PHP
 */

require_once __DIR__ . '/../config/config.php';

$instagramModel = new Instagram();
$instagramPosts = $instagramModel->getPosts();

$posts = [];
$totalPosts = 0;
$totalPages = 0;
$categories = [];

try {
    $postModel = new Post();
    $categoryModel = new Category();
    
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max(1, $page);
    
    // Esta chamada agora funciona corretamente graças à correção no models/Post.php
    $posts = $postModel->getAllPublished($page);
    $totalPosts = $postModel->countPublished();

    // ===================================================================
    // LINHA CORRIGIDA AQUI
    // ===================================================================
    // Usamos a função get_setting() para obter o número de posts por página do painel admin
    $posts_per_page = (int) get_setting('posts_per_page', 8);
    // Garantimos que não haja divisão por zero se a configuração for inválida
    $totalPages = ($posts_per_page > 0) ? ceil($totalPosts / $posts_per_page) : 0;
    // ===================================================================
    
    $categories = $categoryModel->getAll();
} catch (Exception $e) {
    if (DEBUG_MODE) {
        error_log("Failed to load posts: " . $e->getMessage());
    }
    // Se algo der errado, a variável $posts permanecerá vazia
    $posts = [];
}

$pageTitle = 'Início';
include __DIR__ . '/../views/header.php';
?>

<main class="container-fluid px-0">
    <section class="instagram-feed-section">
        <div class="container">
            <div class="instagram-feed-header">
                <div class="instagram-badge">
                    <i class="bi bi-instagram"></i>
                    <span>Instagram @<?php echo SITE_INSTAGRAM_USERNAME; ?></span>
                </div>
                <h2>Acompanhe Nossas Novidades</h2>
                <p class="text-muted">Fique por dentro das últimas atividades da OAB Gaspar</p>
            </div>
            
            <div class="instagram-carousel">
                <?php foreach ($instagramPosts as $igPost): ?>
                    <div class="instagram-post text-decoration-none" 
                         data-bs-toggle="modal" 
                         data-bs-target="#instagramModal"
                         data-image="<?php echo htmlspecialchars($igPost['image']); ?>"
                         data-caption="<?php echo htmlspecialchars($igPost['full_caption'] ?? $igPost['caption']); ?>"
                         data-date="<?php echo htmlspecialchars($igPost['date']); ?>"
                         data-link="<?php echo htmlspecialchars($igPost['link']); ?>"
                         data-type="<?php echo htmlspecialchars($igPost['type']); ?>"
                         role="button"
                         tabindex="0">
                        <div class="instagram-post-image">
                            <img src="<?php echo htmlspecialchars($igPost['image']); ?>" 
                                 alt="Instagram Post">
                            <div class="instagram-post-overlay">
                                <i class="bi bi-instagram"></i>
                            </div>
                        </div>
                        <div class="instagram-post-content">
                            <p class="instagram-post-caption">
                                <?php echo htmlspecialchars($igPost['caption']); ?>
                            </p>
                            <div class="instagram-post-meta">
                                <span class="instagram-post-date">
                                    <i class="bi bi-clock"></i>
                                    <?php echo htmlspecialchars($igPost['date']); ?>
                                </span>
                                <?php if ($igPost['type'] === 'video'): ?>
                                    <span><i class="bi bi-play-circle"></i></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="instagram-view-all">
                <a href="<?php echo get_setting('instagram_url', '#'); ?>" target="_blank">
                    <i class="bi bi-instagram"></i>
                    Ver Perfil Completo
                </a>
            </div>
        </div>
    </section>
    
    <div class="container py-4">
        <div class="row g-4">
            <?php if (empty($posts)): ?>
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        Nenhuma notícia encontrada no momento.
                    </div>
                </div>
            <?php else: ?>
                <?php foreach ($posts as $post): ?>
                    <div class="col-md-6 col-lg-3">
                        <div class="card post-card h-100 shadow-sm">
                            <?php if ($post['image']): ?>
                                <img src="<?php echo htmlspecialchars($post['image']); ?>" 
                                     class="card-img-top" 
                                     alt="<?php echo htmlspecialchars($post['title']); ?>"
                                     style="height: 200px; object-fit: cover;">
                            <?php else: ?>
                                <div class="card-img-top bg-secondary d-flex align-items-center justify-content-center" 
                                     style="height: 200px;">
                                    <i class="bi bi-image fs-1 text-white"></i>
                                </div>
                            <?php endif; ?>
                            
                            <div class="card-body d-flex flex-column">
                                <?php if ($post['category_name']): ?>
                                    <span class="badge mb-2" 
                                          style="background-color: <?php echo htmlspecialchars($post['category_color']); ?>; width: fit-content;">
                                        <?php echo htmlspecialchars($post['category_name']); ?>
                                    </span>
                                <?php endif; ?>
                                
                                <h5 class="card-title">
                                    <a href="post.php?slug=<?php echo htmlspecialchars($post['slug']); ?>" 
                                       class="text-decoration-none text-dark">
                                        <?php echo htmlspecialchars($post['title']); ?>
                                    </a>
                                </h5>
                                
                                <?php if ($post['excerpt']): ?>
                                    <p class="card-text text-muted small flex-grow-1">
                                        <?php echo htmlspecialchars(substr($post['excerpt'], 0, 100)) . '...'; ?>
                                    </p>
                                <?php endif; ?>
                                
                                <div class="d-flex justify-content-between align-items-center mt-auto">
                                    <small class="text-muted">
                                        <i class="bi bi-eye"></i> <?php echo $post['views']; ?>
                                        <i class="bi bi-chat ms-2"></i> <?php echo $post['comments_count']; ?>
                                    </small>
                                    <a href="post.php?slug=<?php echo htmlspecialchars($post['slug']); ?>" 
                                       class="btn btn-sm btn-primary">
                                        Abrir
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        
        <?php if ($totalPages > 1): ?>
            <nav aria-label="Navegação de posts" class="mt-5">
                <ul class="pagination justify-content-center">
                    <?php if ($page > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="?page=<?php echo $page - 1; ?>">Anterior</a>
                        </li>
                    <?php endif; ?>
                    
                    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                        <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                    <?php endfor; ?>
                    
                    <?php if ($page < $totalPages): ?>
                        <li class="page-item">
                            <a class="page-link" href="?page=<?php echo $page + 1; ?>">Próximo</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        <?php endif; ?>
        
        <?php if ($page < $totalPages): ?>
            <div class="text-center mt-4">
                <a href="?page=<?php echo $page + 1; ?>" class="btn btn-outline-primary btn-lg">
                    Veja mais
                </a>
            </div>
        <?php endif; ?>
    </div>
</main>

<!-- Modal do Instagram -->
<div class="modal fade" id="instagramModal" tabindex="-1" aria-labelledby="instagramModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content instagram-modal">
            <div class="modal-header border-0">
                <h5 class="modal-title" id="instagramModalLabel">
                    <i class="bi bi-instagram"></i>
                    @<?php echo SITE_INSTAGRAM_USERNAME; ?>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
            </div>
            <div class="modal-body p-0">
                <div class="row g-0">
                    <div class="col-md-7">
                        <div class="instagram-modal-image">
                            <img id="modalImage" src="" alt="Instagram Post" class="img-fluid w-100">
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="instagram-modal-content">
                            <div class="instagram-modal-header">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="instagram-avatar">
                                        <i class="bi bi-briefcase-fill"></i>
                                    </div>
                                    <strong>@<?php echo SITE_INSTAGRAM_USERNAME; ?></strong>
                                </div>
                            </div>
                            <div class="instagram-modal-caption">
                                <p id="modalCaption"></p>
                            </div>
                            <div class="instagram-modal-meta">
                                <small class="text-muted">
                                    <i class="bi bi-clock"></i>
                                    <span id="modalDate"></span>
                                </small>
                            </div>
                            <div class="instagram-modal-actions">
                                <a id="modalLink" href="#" target="_blank" class="btn btn-instagram w-100">
                                    <i class="bi bi-instagram"></i>
                                    Ver no Instagram
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../views/footer.php'; ?>