<?php
/**
 * Página de Categoria
 */

require_once __DIR__ . '/../config/config.php';

$postModel = new Post();
$categoryModel = new Category();

$slug = $_GET['slug'] ?? '';
$category = $categoryModel->getBySlug($slug);

if (!$category) {
    header('HTTP/1.0 404 Not Found');
    include __DIR__ . '/../views/404.php';
    exit;
}

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = max(1, $page);

$posts = $postModel->getByCategory($slug, $page);

$pageTitle = $category['name'];
include __DIR__ . '/../views/header.php';
?>

<main class="container py-4">
    <div class="category-header mb-4">
        <h1 class="display-5">
            <span class="badge" style="background-color: <?php echo htmlspecialchars($category['color']); ?>;">
                <?php echo htmlspecialchars($category['name']); ?>
            </span>
        </h1>
        <?php if ($category['description']): ?>
            <p class="lead text-muted"><?php echo htmlspecialchars($category['description']); ?></p>
        <?php endif; ?>
    </div>
    
    <?php if (empty($posts)): ?>
        <div class="alert alert-info">
            <i class="bi bi-info-circle"></i> Nenhum post encontrado nesta categoria.
        </div>
    <?php else: ?>
        <div class="row g-4">
            <?php foreach ($posts as $post): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="card post-card h-100 shadow-sm">
                        <?php if ($post['image']): ?>
                            <img src="<?php echo htmlspecialchars($post['image']); ?>" 
                                 class="card-img-top" 
                                 alt="<?php echo htmlspecialchars($post['title']); ?>"
                                 style="height: 200px; object-fit: cover;">
                        <?php else: ?>
                            <div class="card-img-top bg-secondary d-flex align-items-center justify-content-center" 
                                 style="height: 200px;">
                                <i class="bi bi-image fs-1 text-white"></i>
                            </div>
                        <?php endif; ?>
                        
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title">
                                <a href="post.php?slug=<?php echo htmlspecialchars($post['slug']); ?>" 
                                   class="text-decoration-none text-dark">
                                    <?php echo htmlspecialchars($post['title']); ?>
                                </a>
                            </h5>
                            
                            <?php if ($post['excerpt']): ?>
                                <p class="card-text text-muted small flex-grow-1">
                                    <?php echo htmlspecialchars(substr($post['excerpt'], 0, 100)) . '...'; ?>
                                </p>
                            <?php endif; ?>
                            
                            <div class="d-flex justify-content-between align-items-center mt-auto">
                                <small class="text-muted">
                                    <i class="bi bi-eye"></i> <?php echo $post['views']; ?>
                                    <i class="bi bi-chat ms-2"></i> <?php echo $post['comments_count']; ?>
                                </small>
                                <a href="post.php?slug=<?php echo htmlspecialchars($post['slug']); ?>" 
                                   class="btn btn-sm btn-primary">
                                    Abrir
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</main>

<?php include __DIR__ . '/../views/footer.php'; ?>
