/**
 * JavaScript Principal
 * OAB Gaspar Clone - Versão PHP
 */

document.addEventListener('DOMContentLoaded', function() {
    
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
    
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        if (!alert.classList.contains('alert-permanent')) {
            setTimeout(() => {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            }, 5000);
        }
    });
    
    if ('IntersectionObserver' in window) {
        const imageObserver = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    if (img.dataset.src) {
                        img.src = img.dataset.src;
                        img.removeAttribute('data-src');
                        observer.unobserve(img);
                    }
                }
            });
        });
        
        document.querySelectorAll('img[data-src]').forEach(img => {
            imageObserver.observe(img);
        });
    }
    
    const forms = document.querySelectorAll('.needs-validation');
    forms.forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
    
    const textareas = document.querySelectorAll('textarea[maxlength]');
    textareas.forEach(textarea => {
        const maxLength = textarea.getAttribute('maxlength');
        const counter = document.createElement('small');
        counter.className = 'text-muted';
        counter.textContent = `0/${maxLength}`;
        textarea.parentNode.appendChild(counter);
        
        textarea.addEventListener('input', function() {
            counter.textContent = `${this.value.length}/${maxLength}`;
        });
    });
    
    const deleteButtons = document.querySelectorAll('[data-confirm-delete]');
    deleteButtons.forEach(button => {
        button.addEventListener('click', function(e) {
            if (!confirm('Tem certeza que deseja deletar este item?')) {
                e.preventDefault();
            }
        });
    });
    
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    const popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
    popoverTriggerList.map(function (popoverTriggerEl) {
        return new bootstrap.Popover(popoverTriggerEl);
    });
    
    const instagramCarousel = document.querySelector('.instagram-carousel');
    if (instagramCarousel) {
        let isDown = false;
        let startX;
        let scrollLeft;
        let hasMoved = false;

        instagramCarousel.addEventListener('mousedown', (e) => {
            if (e.target.closest('.instagram-post')) {
                isDown = true;
                hasMoved = false;
                instagramCarousel.style.cursor = 'grabbing';
                startX = e.pageX - instagramCarousel.offsetLeft;
                scrollLeft = instagramCarousel.scrollLeft;
            }
        });

        instagramCarousel.addEventListener('mouseleave', () => {
            isDown = false;
            instagramCarousel.style.cursor = 'grab';
        });

        instagramCarousel.addEventListener('mouseup', () => {
            isDown = false;
            instagramCarousel.style.cursor = 'grab';
        });

        instagramCarousel.addEventListener('mousemove', (e) => {
            if (!isDown) return;
            const x = e.pageX - instagramCarousel.offsetLeft;
            const distance = Math.abs(x - startX);
            
            if (distance > 5) {
                hasMoved = true;
                e.preventDefault();
                const walk = (x - startX) * 2;
                instagramCarousel.scrollLeft = scrollLeft - walk;
            }
        });
        
        document.querySelectorAll('.instagram-post').forEach(post => {
            post.addEventListener('click', (e) => {
                if (hasMoved) {
                    e.preventDefault();
                    e.stopPropagation();
                }
            });
        });
    }
    
    const instagramModal = document.getElementById('instagramModal');
    if (instagramModal) {
        instagramModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const image = button.getAttribute('data-image');
            const caption = button.getAttribute('data-caption');
            const date = button.getAttribute('data-date');
            const link = button.getAttribute('data-link');
            
            const modalImage = instagramModal.querySelector('#modalImage');
            const modalCaption = instagramModal.querySelector('#modalCaption');
            const modalDate = instagramModal.querySelector('#modalDate');
            const modalLink = instagramModal.querySelector('#modalLink');
            
            modalImage.src = image;
            modalCaption.textContent = caption;
            modalDate.textContent = date;
            modalLink.href = link;
        });
    }
    
});

function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
        alert('Texto copiado!');
    }).catch(err => {
        console.error('Erro ao copiar:', err);
    });
}

function shareContent(title, text, url) {
    if (navigator.share) {
        navigator.share({
            title: title,
            text: text,
            url: url
        }).catch(err => console.error('Erro ao compartilhar:', err));
    } else {
        copyToClipboard(url);
    }
}
