<?php
session_start();

require_once '../../models/User.php';
require_once '../../models/Post.php';
require_once '../../models/Category.php';


User::requireAdmin();
define('ADMIN_ACCESS', true);

$postModel = new Post();
$categoryModel = new Category();
$categories = $categoryModel->getAll();

$action = $_GET['action'] ?? 'list';
$message = $_SESSION['message'] ?? '';
unset($_SESSION['message']);

$page_title = 'Gerenciamento de Notícias';

// Função auxiliar para gerar slug
function slugify($text, string $divider = '-')
{
    // replace non letter or digits by divider
    $text = preg_replace('~[^\pL\d]+~u', $divider, $text);

    // transliterate
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

    // remove unwanted characters
    $text = preg_replace('~[^-\w]+~', '', $text);

    // trim
    $text = trim($text, $divider);

    // remove duplicate divider
    $text = preg_replace('~-+~', $divider, $text);

    // lowercase
    $text = strtolower($text);

    if (empty($text)) {
        return 'n-a';
    }

    return $text;
}

switch ($action) {
    case 'list':
        $posts = $postModel->getAll();
        include '../../views/admin_posts_list.php';
        break;

    case 'create':
    case 'edit':
        $post = null;
        if ($action === 'edit' && isset($_GET['id'])) {
            $post = $postModel->getById($_GET['id']);
            if (!$post) {
                $_SESSION['message'] = "Post não encontrado.";
                header('Location: posts.php');
                exit;
            }
        }
        include '../../views/admin_post_form.php';
        break;

    case 'save':
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $id = $_POST['id'] ?? null;
            $title = trim($_POST['title'] ?? '');
            $content = $_POST['content'] ?? '';
            $excerpt = $_POST['excerpt'] ?? '';
            $category_id = $_POST['category_id'] ?? null;
            $image = $_POST['image'] ?? '';
            $status = $_POST['status'] ?? 'draft';
            $published_at = ($status === 'published') ? date('Y-m-d H:i:s') : null;
            $author_id = $_SESSION['user_id'] ?? 1; // Usar o ID do usuário logado

            if (empty($title) || empty($content) || empty($category_id)) {
                $_SESSION['message'] = "Erro: Título, Conteúdo e Categoria são obrigatórios.";
                header('Location: posts.php?action=' . ($id ? 'edit&id=' . $id : 'create'));
                exit;
            }

            $slug = slugify($title);

            $data = [
                'title' => $title,
                'slug' => $slug,
                'content' => $content,
                'excerpt' => $excerpt,
                'image' => $image,
                'category_id' => $category_id,
                'author_id' => $author_id,
                'status' => $status,
                'published_at' => $published_at
            ];

            if ($id) {
                // Atualizar
                if ($postModel->update($id, $data)) {
                    $_SESSION['message'] = "Notícia atualizada com sucesso!";
                } else {
                    $_SESSION['message'] = "Erro ao atualizar notícia.";
                }
            } else {
                // Criar
                if ($postModel->create($data)) {
                    $_SESSION['message'] = "Notícia criada com sucesso!";
                } else {
                    $_SESSION['message'] = "Erro ao criar notícia.";
                }
            }
        }
        header('Location: posts.php');
        exit;

    case 'delete':
        if (isset($_GET['id'])) {
            if ($postModel->delete($_GET['id'])) {
                $_SESSION['message'] = "Notícia excluída com sucesso!";
            } else {
                $_SESSION['message'] = "Erro ao excluir notícia.";
            }
        }
        header('Location: posts.php');
        exit;

    default:
        header('Location: posts.php');
        exit;
}
?>
