<?php
session_start();
require_once '../../models/User.php';
require_once '../../models/Page.php';

User::requireAdmin();
define('ADMIN_ACCESS', true);

$pageModel = new Page();

$action = $_GET['action'] ?? 'list';
$message = $_SESSION['message'] ?? '';
unset($_SESSION['message']);

$page_title = 'Gerenciamento de Páginas';

// Função auxiliar para gerar slug (copiada de posts.php para evitar dependência)
function slugify($text, string $divider = '-')
{
    // replace non letter or digits by divider
    $text = preg_replace('~[^\pL\d]+~u', $divider, $text);

    // transliterate
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

    // remove unwanted characters
    $text = preg_replace('~[^-\w]+~', '', $text);

    // trim
    $text = trim($text, $divider);

    // remove duplicate divider
    $text = preg_replace('~-+~', $divider, $text);

    // lowercase
    $text = strtolower($text);

    if (empty($text)) {
        return 'n-a';
    }

    return $text;
}

switch ($action) {
    case 'list':
        $pages = $pageModel->getAll();
        include '../../views/admin_pages_list.php';
        break;

    case 'create':
    case 'edit':
        $page = null;
        $all_pages = $pageModel->getAll(); // Para a seleção de página pai
        if ($action === 'edit' && isset($_GET['id'])) {
            $page = $pageModel->getById($_GET['id']);
            if (!$page) {
                $_SESSION['message'] = "Página não encontrada.";
                header('Location: pages.php');
                exit;
            }
        }
        include '../../views/admin_page_form.php';
        break;

    case 'save':
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $id = $_POST['id'] ?? null;
            $title = trim($_POST['title'] ?? '');
            $content = $_POST['content'] ?? '';
            $status = $_POST['status'] ?? 'draft';
            $parent_id = $_POST['parent_id'] ?? null;
            $menu_order = $_POST['menu_order'] ?? 0;

            if (empty($title) || empty($content)) {
                $_SESSION['message'] = "Erro: Título e Conteúdo são obrigatórios.";
                header('Location: pages.php?action=' . ($id ? 'edit&id=' . $id : 'create'));
                exit;
            }

            $slug = slugify($title);

            if ($id) {
                // Atualizar
                if ($pageModel->update($id, $title, $slug, $content, $status, $parent_id, $menu_order)) {
                    $_SESSION['message'] = "Página atualizada com sucesso!";
                } else {
                    $_SESSION['message'] = "Erro ao atualizar página.";
                }
            } else {
                // Criar
                if ($pageModel->create($title, $slug, $content, $status, $parent_id, $menu_order)) {
                    $_SESSION['message'] = "Página criada com sucesso!";
                } else {
                    $_SESSION['message'] = "Erro ao criar página.";
                }
            }
        }
        header('Location: pages.php');
        exit;

    case 'delete':
        if (isset($_GET['id'])) {
            if ($pageModel->delete($_GET['id'])) {
                $_SESSION['message'] = "Página excluída com sucesso!";
            } else {
                $_SESSION['message'] = "Erro ao excluir página.";
            }
        }
        header('Location: pages.php');
        exit;

    default:
        header('Location: pages.php');
        exit;
}
?>
