<?php
session_start();
require_once '../../models/User.php';

// Se o usuário já estiver logado, redireciona para o dashboard
if (User::isLoggedIn()) {
    header("Location: index.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = "Por favor, preencha todos os campos.";
    } else {
        $user = new User();
        if ($user->findByUsername($username)) {
            if ($user->verifyPassword($password)) {
                // Login bem-sucedido
                $_SESSION['user_id'] = $user->id;
                $_SESSION['username'] = $user->username;
                $_SESSION['user_role'] = $user->role;
                
                header("Location: index.php");
                exit;
            } else {
                $error = "Usuário ou senha inválidos.";
            }
        } else {
            $error = "Usuário ou senha inválidos.";
        }
    }
}

// Incluir o template de login
include '../../views/admin_login.php';
?>
