<?php
session_start();
require_once '../../models/User.php';

// Requer autenticação de administrador
User::requireAdmin();

define('ADMIN_ACCESS', true);
$page_title = 'Dashboard';

// Incluir o cabeçalho
include '../../views/admin_header.php';
?>

<div class="container-fluid">
    <h1>Dashboard Administrativo</h1>
    <p>Bem-vindo ao painel de controle da OAB. Use o menu lateral para gerenciar o conteúdo do site.</p>

    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-header">Notícias</div>
                <div class="card-body">
                    <h5 class="card-title">Gerenciar Posts</h5>
                    <p class="card-text">Crie, edite e exclua as notícias e artigos do blog.</p>
                    <a href="posts.php" class="btn btn-light">Acessar</a>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3">
                <div class="card-header">Páginas</div>
                <div class="card-body">
                    <h5 class="card-title">Gerenciar Páginas Estáticas</h5>
                    <p class="card-text">Modifique o conteúdo das páginas institucionais (Ex: Sobre, Contato).</p>
                    <a href="pages.php" class="btn btn-light">Acessar</a>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-info mb-3">
                <div class="card-header">Usuários</div>
                <div class="card-body">
                    <h5 class="card-title">Gerenciar Acessos</h5>
                    <p class="card-text">Gerencie os usuários com acesso ao painel administrativo.</p>
                    <a href="#" class="btn btn-light disabled">Em Breve</a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// Incluir o rodapé
include '../../views/admin_footer.php';
?>
