<?php
/**
 * Configuração do Sistema Admin
 * Inclui a configuração do banco de dados existente
 */

// Incluir configuração do banco de dados principal
require_once '../config/database.php';
require_once '../config/config.php';

// Configurações específicas do admin
define('ADMIN_SESSION_NAME', 'oab_admin_session');
define('ADMIN_COOKIE_LIFETIME', 3600 * 8); // 8 horas
define('ADMIN_MAX_LOGIN_ATTEMPTS', 5);
define('ADMIN_LOCKOUT_TIME', 900); // 15 minutos

// Função para obter conexão do banco
function getDB() {
    $db = Database::getInstance();
    return $db->getConnection();
}

// Iniciar sessão se não estiver iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_name(ADMIN_SESSION_NAME);
    session_start();
}
?>
