<?php
/**
 * Sistema de Autenticação do Admin
 */

// Incluir configuração
require_once 'config.php';

// Inicia sessão se não estiver iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Função para verificar se está logado
function isAdminLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

// Função para proteger páginas admin
function requireAdminAuth() {
    if (!isAdminLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

// Função para logout
function adminLogout() {
    $_SESSION = array();
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    session_destroy();
    header('Location: login.php');
    exit;
}

// Função para obter dados do usuário logado
function getAdminUser() {
    if (!isAdminLoggedIn()) {
        return null;
    }
    
    return [
        'id' => $_SESSION['admin_user_id'],
        'username' => $_SESSION['admin_username'],
        'name' => $_SESSION['admin_name'],
        'role' => $_SESSION['admin_role']
    ];
}

// Função para verificar permissões
function hasPermission($required_role = 'editor') {
    $user = getAdminUser();
    if (!$user) return false;
    
    $roles = ['editor' => 1, 'admin' => 2];
    $user_level = $roles[$user['role']] ?? 0;
    $required_level = $roles[$required_role] ?? 1;
    
    return $user_level >= $required_level;
}

// Processar logout se solicitado
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    adminLogout();
}
