<?php
/**
 * Configurações do Site
 */

require_once __DIR__ . '/../../config/config.php';
require_once 'auth.php';

// Protege a página
requireAdminAuth();

$user = getAdminUser();
$db = Database::getInstance()->getConnection();

$message = '';
$error = '';

// Salvar configurações
if ($_POST && isset($_POST['save_settings'])) {
    try {
        $settings = [
            'site_title' => $_POST['site_title'],
            'site_description' => $_POST['site_description'],
            'site_keywords' => $_POST['site_keywords'],
            'contact_email' => $_POST['contact_email'],
            'contact_phone' => $_POST['contact_phone'],
            'contact_address' => $_POST['contact_address'],
            'facebook_url' => $_POST['facebook_url'],
            'instagram_url' => $_POST['instagram_url'],
            'twitter_url' => $_POST['twitter_url'],
            'linkedin_url' => $_POST['linkedin_url'],
            'posts_per_page' => (int)$_POST['posts_per_page'],
            'maintenance_mode' => isset($_POST['maintenance_mode']) ? 1 : 0,
            'allow_comments' => isset($_POST['allow_comments']) ? 1 : 0,
            'google_analytics' => $_POST['google_analytics'],
            'footer_text' => $_POST['footer_text']
        ];

        foreach ($settings as $key => $value) {
            // CORREÇÃO APLICADA AQUI
            $stmt = $db->prepare("
                INSERT INTO settings (setting_key, setting_value) 
                VALUES (?, ?) 
                ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
            ");
            $stmt->execute([$key, $value]);
        }

        $message = "Configurações salvas com sucesso!";
    } catch (Exception $e) {
        $error = "Erro ao salvar configurações: " . $e->getMessage();
    }
}

// Carregar configurações atuais
$current_settings = [];
try {
    // CORREÇÃO APLICADA AQUI
    $stmt = $db->query("SELECT setting_key, setting_value FROM settings");
    while ($row = $stmt->fetch()) {
        $current_settings[$row['setting_key']] = $row['setting_value'];
    }
} catch (Exception $e) {
    $error = "Erro ao carregar configurações: " . $e->getMessage();
}

// Valores padrão
$defaults = [
    'site_title' => 'OAB Gaspar',
    'site_description' => 'Ordem dos Advogados do Brasil - Subseção Gaspar',
    'site_keywords' => 'OAB, Gaspar, Advogados, Direito',
    'contact_email' => '',
    'contact_phone' => '',
    'contact_address' => '',
    'facebook_url' => '',
    'instagram_url' => '',
    'twitter_url' => '',
    'linkedin_url' => '',
    'posts_per_page' => 10,
    'maintenance_mode' => 0,
    'allow_comments' => 1,
    'google_analytics' => '',
    'footer_text' => '© 2024 OAB Gaspar. Todos os direitos reservados.'
];

// Mesclar com valores atuais
$settings = array_merge($defaults, $current_settings);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações - Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <!-- Header -->
    <header class="bg-blue-900 text-white shadow-lg">
        <div class="container mx-auto px-4 py-3">
            <div class="flex justify-between items-center">
                <div class="flex items-center space-x-4">
                    <a href="index.php" class="text-white hover:text-gray-300">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Voltar ao Dashboard
                    </a>
                    <h1 class="text-xl font-bold">Configurações do Site</h1>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="text-sm">
                        <i class="fas fa-user mr-1"></i>
                        <?php echo htmlspecialchars($user['name']); ?>
                    </span>
                    <a href="?action=logout" class="bg-red-600 hover:bg-red-700 px-3 py-1 rounded text-sm">
                        <i class="fas fa-sign-out-alt mr-1"></i>
                        Sair
                    </a>
                </div>
            </div>
        </div>
    </header>

    <div class="container mx-auto px-4 py-6">
        <!-- Mensagens -->
        <?php if ($message): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>

        <form method="POST" class="space-y-6">
            <!-- Informações Gerais -->
            <div class="bg-white rounded-lg shadow">
                <div class="p-6 border-b">
                    <h2 class="text-xl font-semibold">Informações Gerais</h2>
                </div>
                <div class="p-6 grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Título do Site</label>
                        <input type="text" name="site_title" required
                               value="<?php echo htmlspecialchars($settings['site_title']); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Descrição do Site</label>
                        <textarea name="site_description" rows="3"
                                  class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo htmlspecialchars($settings['site_description']); ?></textarea>
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Palavras-chave (SEO)</label>
                        <input type="text" name="site_keywords"
                               value="<?php echo htmlspecialchars($settings['site_keywords']); ?>"
                               placeholder="Separadas por vírgula"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Posts por Página</label>
                        <input type="number" name="posts_per_page" min="1" max="50"
                               value="<?php echo htmlspecialchars($settings['posts_per_page']); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div class="flex items-center space-x-6 pt-6">
                        <div class="flex items-center">
                            <input type="checkbox" name="maintenance_mode" id="maintenance_mode" value="1" 
                                   <?php echo $settings['maintenance_mode'] ? 'checked' : ''; ?>
                                   class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="maintenance_mode" class="ml-2 block text-sm text-gray-900">
                                Modo Manutenção
                            </label>
                        </div>

                        <div class="flex items-center">
                            <input type="checkbox" name="allow_comments" id="allow_comments" value="1" 
                                   <?php echo $settings['allow_comments'] ? 'checked' : ''; ?>
                                   class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="allow_comments" class="ml-2 block text-sm text-gray-900">
                                Permitir Comentários
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Informações de Contato -->
            <div class="bg-white rounded-lg shadow">
                <div class="p-6 border-b">
                    <h2 class="text-xl font-semibold">Informações de Contato</h2>
                </div>
                <div class="p-6 grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Email de Contato</label>
                        <input type="email" name="contact_email"
                               value="<?php echo htmlspecialchars($settings['contact_email']); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Telefone</label>
                        <input type="text" name="contact_phone"
                               value="<?php echo htmlspecialchars($settings['contact_phone']); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Endereço</label>
                        <textarea name="contact_address" rows="3"
                                  class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo htmlspecialchars($settings['contact_address']); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Redes Sociais -->
            <div class="bg-white rounded-lg shadow">
                <div class="p-6 border-b">
                    <h2 class="text-xl font-semibold">Redes Sociais</h2>
                </div>
                <div class="p-6 grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fab fa-facebook mr-2"></i>Facebook
                        </label>
                        <input type="url" name="facebook_url"
                               value="<?php echo htmlspecialchars($settings['facebook_url']); ?>"
                               placeholder="https://facebook.com/..."
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fab fa-instagram mr-2"></i>Instagram
                        </label>
                        <input type="url" name="instagram_url"
                               value="<?php echo htmlspecialchars($settings['instagram_url']); ?>"
                               placeholder="https://instagram.com/..."
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fab fa-twitter mr-2"></i>Twitter
                        </label>
                        <input type="url" name="twitter_url"
                               value="<?php echo htmlspecialchars($settings['twitter_url']); ?>"
                               placeholder="https://twitter.com/..."
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fab fa-linkedin mr-2"></i>LinkedIn
                        </label>
                        <input type="url" name="linkedin_url"
                               value="<?php echo htmlspecialchars($settings['linkedin_url']); ?>"
                               placeholder="https://linkedin.com/..."
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>
            </div>

            <!-- Configurações Avançadas -->
            <div class="bg-white rounded-lg shadow">
                <div class="p-6 border-b">
                    <h2 class="text-xl font-semibold">Configurações Avançadas</h2>
                </div>
                <div class="p-6 space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Google Analytics ID</label>
                        <input type="text" name="google_analytics"
                               value="<?php echo htmlspecialchars($settings['google_analytics']); ?>"
                               placeholder="G-XXXXXXXXXX"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">ID do Google Analytics para rastreamento</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Texto do Rodapé</label>
                        <textarea name="footer_text" rows="2"
                                  class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo htmlspecialchars($settings['footer_text']); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Botão Salvar -->
            <div class="flex justify-end">
                <button type="submit" name="save_settings" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg">
                    <i class="fas fa-save mr-2"></i>
                    Salvar Configurações
                </button>
            </div>
        </form>
    </div>
</body>
</html>