<?php
/**
 * Painel Principal do Admin
 */

require_once __DIR__ . '/../../config/config.php';
require_once 'auth.php';

// Protege a página
requireAdminAuth();

$user = getAdminUser();

// Estatísticas básicas
try {
    $db = Database::getInstance()->getConnection();
    
    // Contar posts
    $stmt = $db->query("SELECT COUNT(*) as total FROM posts");
    $total_posts = $stmt->fetch()['total'];
    
    // Contar páginas
    $stmt = $db->query("SELECT COUNT(*) as total FROM pages");
    $total_pages = $stmt->fetch()['total'];
    
    // Contar comentários
    $stmt = $db->query("SELECT COUNT(*) as total FROM comments");
    $total_comments = $stmt->fetch()['total'];
    
    // Posts recentes
    $stmt = $db->query("SELECT id, title, created_at FROM posts ORDER BY created_at DESC LIMIT 5");
    $recent_posts = $stmt->fetchAll();
    
} catch (Exception $e) {
    $error = "Erro ao carregar dados: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- LINHA CORRIGIDA ABAIXO -->
    <title>Painel Admin - <?php echo get_setting('site_title', 'Painel Admin'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <!-- Header -->
    <header class="bg-blue-900 text-white shadow-lg">
        <div class="container mx-auto px-4 py-3">
            <div class="flex justify-between items-center">
                <div class="flex items-center space-x-4">
                    <h1 class="text-xl font-bold">
                        <i class="fas fa-cogs mr-2"></i>
                        Painel Admin
                    </h1>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="text-sm">
                        <i class="fas fa-user mr-1"></i>
                        Olá, <?php echo htmlspecialchars($user['name']); ?>
                    </span>
                    <a href="?action=logout" class="bg-red-600 hover:bg-red-700 px-3 py-1 rounded text-sm">
                        <i class="fas fa-sign-out-alt mr-1"></i>
                        Sair
                    </a>
                </div>
            </div>
        </div>
    </header>

    <div class="flex">
        <!-- Sidebar -->
        <nav class="bg-blue-800 text-white w-64 min-h-screen">
            <div class="p-4">
                <ul class="space-y-2">
                    <li>
                        <a href="index.php" class="flex items-center space-x-2 p-2 rounded bg-blue-700">
                            <i class="fas fa-dashboard"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>
                    <li>
                        <a href="posts.php" class="flex items-center space-x-2 p-2 rounded hover:bg-blue-700">
                            <i class="fas fa-newspaper"></i>
                            <span>Notícias</span>
                        </a>
                    </li>
                    <li>
                        <a href="pages.php" class="flex items-center space-x-2 p-2 rounded hover:bg-blue-700">
                            <i class="fas fa-file-alt"></i>
                            <span>Páginas</span>
                        </a>
                    </li>
                    <li>
                        <a href="categories.php" class="flex items-center space-x-2 p-2 rounded hover:bg-blue-700">
                            <i class="fas fa-tags"></i>
                            <span>Categorias</span>
                        </a>
                    </li>
                    <li>
                        <a href="comments.php" class="flex items-center space-x-2 p-2 rounded hover:bg-blue-700">
                            <i class="fas fa-comments"></i>
                            <span>Comentários</span>
                        </a>
                    </li>
                    <li>
                        <a href="settings.php" class="flex items-center space-x-2 p-2 rounded hover:bg-blue-700">
                            <i class="fas fa-cog"></i>
                            <span>Configurações</span>
                        </a>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Main Content -->
        <main class="flex-1 p-6">
            <?php if (isset($error)): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <div class="mb-6">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Dashboard</h2>
                <p class="text-gray-600">Bem-vindo ao painel de administração</p>
            </div>

            <!-- Estatísticas -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <div class="bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-blue-100 text-blue-600">
                            <i class="fas fa-newspaper text-2xl"></i>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-lg font-semibold text-gray-700">Notícias</h3>
                            <p class="text-3xl font-bold text-blue-600"><?php echo $total_posts ?? 0; ?></p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-green-100 text-green-600">
                            <i class="fas fa-file-alt text-2xl"></i>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-lg font-semibold text-gray-700">Páginas</h3>
                            <p class="text-3xl font-bold text-green-600"><?php echo $total_pages ?? 0; ?></p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-yellow-100 text-yellow-600">
                            <i class="fas fa-comments text-2xl"></i>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-lg font-semibold text-gray-700">Comentários</h3>
                            <p class="text-3xl font-bold text-yellow-600"><?php echo $total_comments ?? 0; ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Posts Recentes -->
            <div class="bg-white rounded-lg shadow">
                <div class="p-6 border-b">
                    <h3 class="text-lg font-semibold text-gray-800">Notícias Recentes</h3>
                </div>
                <div class="p-6">
                    <?php if (!empty($recent_posts)): ?>
                        <div class="space-y-3">
                            <?php foreach ($recent_posts as $post): ?>
                                <div class="flex items-center justify-between p-3 bg-gray-50 rounded">
                                    <div>
                                        <h4 class="font-medium text-gray-800">
                                            <?php echo htmlspecialchars($post['title']); ?>
                                        </h4>
                                        <p class="text-sm text-gray-600">
                                            <?php echo date('d/m/Y H:i', strtotime($post['created_at'])); ?>
                                        </p>
                                    </div>
                                    <a href="posts.php?action=edit&id=<?php echo $post['id']; ?>" 
                                       class="text-blue-600 hover:text-blue-800">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <p class="text-gray-500">Nenhuma notícia encontrada.</p>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
</body>
</html>