<?php
require_once __DIR__ . '/../config/database.php';

class User {
    private $conn;
    private $table_name = "users";

    public $id;
    public $username;
    public $password;
    public $email;
    public $role;
    public $created_at;

    public function __construct() {
        $database = Database::getInstance();
        $this->conn = $database->getConnection();
    }

    // Método para buscar um usuário pelo nome de usuário
    public function findByUsername($username) {
        $query = "SELECT id, username, password, email, role, created_at
                  FROM " . $this->table_name . "
                  WHERE username = :username
                  LIMIT 0,1";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':username', $username);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->id = $row['id'];
            $this->username = $row['username'];
            $this->password = $row['password'];
            $this->email = $row['email'];
            $this->role = $row['role'];
            $this->created_at = $row['created_at'];
            return true;
        }
        return false;
    }

    // Método para verificar a senha
    public function verifyPassword($password) {
        return password_verify($password, $this->password);
    }

    // Método para verificar se o usuário está logado
    public static function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }

    // Método para garantir que apenas administradores acessem
    public static function requireAdmin() {
        if (!self::isLoggedIn() || $_SESSION['user_role'] !== 'admin') {
            header("Location: login.php");
            exit;
        }
    }
}
?>
