<?php
/**
 * Model de Comentários
 */

class Comment {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }
    
    public function getByPost($postId) {
        $sql = "SELECT * FROM comments 
                WHERE post_id = :post_id AND status = 'approved'
                ORDER BY created_at DESC";
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute(['post_id' => $postId]);
        return $stmt->fetchAll();
    }
    
    public function create($data) {
        $sql = "INSERT INTO comments (post_id, author_name, author_email, content, status)
                VALUES (:post_id, :author_name, :author_email, :content, :status)";
        
        $stmt = $this->db->prepare($sql);
        return $stmt->execute($data);
    }
    
    public function countByPost($postId) {
        $sql = "SELECT COUNT(*) as total FROM comments 
                WHERE post_id = :post_id AND status = 'approved'";
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute(['post_id' => $postId]);
        $result = $stmt->fetch();
        return $result['total'];
    }
}
