<?php
/**
 * Configuração do Banco de Dados
 * OAB Gaspar Clone - Versão PHP
 */

$databaseUrl = getenv('DATABASE_URL');
if ($databaseUrl) {
    $db = parse_url($databaseUrl);
    define('DB_HOST', $db['host']);
    define('DB_NAME', ltrim($db['path'], '/'));
    define('DB_USER', $db['user']);
    define('DB_PASS', $db['pass']);
    define('DB_PORT', $db['port'] ?? 5432);
    define('DB_TYPE', 'pgsql');
} else {
    define('DB_HOST', 'localhost');
    define('DB_NAME', 'oab_gaspar');
    define('DB_USER', 'gabrieljsdb');
    define('DB_PASS', '@Aa016512');
    define('DB_PORT', 3306);
    define('DB_TYPE', 'mysql');
}

class Database {
    private static $instance = null;
    private $conn;
    
    private function __construct() {
        try {
            if (DB_TYPE === 'pgsql') {
                $dsn = "pgsql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME;
            } else {
                $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
            }
            
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            
            $this->conn = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch(PDOException $e) {
            $this->conn = null;
            if (DEBUG_MODE) {
                error_log("DB Connection failed: " . $e->getMessage());
            }
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->conn;
    }
    
    private function __clone() {}
    
    public function __wakeup() {
        throw new Exception("Cannot unserialize singleton");
    }
}
