<?php
/**
 * Configurações Gerais
 * OAB Gaspar Clone - Versão PHP
 */

// As constantes abaixo agora são gerenciadas pelo painel de administração
// define('SITE_NAME', 'OAB Subseção Gaspar');
// define('SITE_EMAIL', 'subgaspar@oab-sc.org.br');
// define('SITE_PHONE', '(47) 3397-0775');
// define('SITE_INSTAGRAM', 'https://instagram.com/gbarcellos1995');

// Constantes que podem permanecer fixas ou ser movidas para o painel no futuro
define('SITE_URL', 'http://localhost');
define('SITE_INSTAGRAM_USERNAME', 'gbarcellos1995');

define('INSTAGRAM_ACCESS_TOKEN', 'IGAAbtMiTTs1JBZAFJyZAkoxeDlEUi05UFFmT1ViWFFBN1h6YXhLLU9ZAT01GVUhhQ2Q1c1BOcU0ycTJNUlNfdHQ0S3B6MTFfNEozTU9SWG51aEhqSmY1U25jRUtFOVBjblJUajhiMllDbm90MVdZAZA3NqaTY1Vm5CVmxoZAUZASWjFZAbwZDZD');
define('INSTAGRAM_CACHE_TIME', 3600);

ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0);

date_default_timezone_set('America/Sao_Paulo');

define('UPLOAD_DIR', __DIR__ . '/../public/uploads/');
define('CACHE_DIR', __DIR__ . '/../cache/');
define('MAX_FILE_SIZE', 5 * 1024 * 1024);
define('ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'gif', 'webp']);

// A constante POSTS_PER_PAGE foi removida para usar a configuração do banco
// define('POSTS_PER_PAGE', 8); 
define('INSTAGRAM_POSTS_LIMIT', 6);

define('DEBUG_MODE', true);

if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

spl_autoload_register(function ($class) {
    $paths = [
        __DIR__ . '/../models/',
        __DIR__ . '/../controllers/',
        __DIR__ . '/../helpers/',
    ];
    
    foreach ($paths as $path) {
        $file = $path . $class . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});

require_once __DIR__ . '/database.php';

// ===================================================================
// CARREGADOR DE CONFIGURAÇÕES DINÂMICAS COM "LAZY LOADING"
// ===================================================================
global $site_settings;
$site_settings = null; // Inicia como nulo para indicar que não foi carregado

/**
 * Função para obter uma configuração do banco de dados de forma "preguiçosa".
 * A consulta ao banco só acontece na primeira vez que a função é chamada.
 *
 * @param string $key A chave da configuração (ex: 'site_title').
 * @param mixed $default O valor padrão a ser retornado se a chave não existir.
 * @return mixed O valor da configuração.
 */
function get_setting($key, $default = '') {
    global $site_settings;

    // Se $site_settings for nulo, significa que ainda não carregamos do banco.
    if ($site_settings === null) {
        $site_settings = []; // Inicializa como um array para evitar múltiplas cargas
        try {
            $db = Database::getInstance()->getConnection();
            if ($db) {
                $stmt = $db->query("SELECT setting_key, setting_value FROM settings");
                while ($row = $stmt->fetch()) {
                    $site_settings[$row['setting_key']] = $row['setting_value'];
                }
            }
        } catch (Exception $e) {
            // Em caso de erro, o array $site_settings ficará vazio, e a função usará os valores padrão.
            if (DEBUG_MODE) {
                error_log("Erro ao carregar configurações do banco: " . $e->getMessage());
            }
        }
    }

    // Agora que as configurações estão carregadas, retorna o valor desejado.
    $value = isset($site_settings[$key]) && !empty($site_settings[$key]) ? $site_settings[$key] : $default;
    return htmlspecialchars($value);
}
// ===================================================================


if (session_status() === PHP_SESSION_NONE) {
    session_start();
}