<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'foxiz_elementor_main_menu' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false
	 */
	function foxiz_elementor_main_menu( $settings = array() ) {

		if ( empty( $settings['main_menu'] ) || ! is_nav_menu( $settings['main_menu'] ) ) {
			return false;
		}
		$args = array(
			'menu'          => $settings['main_menu'],
			'menu_id'       => false,
			'container'     => '',
			'menu_class'    => 'main-menu rb-menu large-menu',
			'walker'        => new Foxiz_Walker_Nav_Menu(),
			'depth'         => 4,
			'items_wrap'    => '<ul id="%1$s" class="%2$s" itemscope itemtype="' . foxiz_protocol() . '://www.schema.org/SiteNavigationElement">%3$s</ul>',
			'echo'          => true,
			'fallback_cb'   => 'foxiz_navigation_fallback',
			'fallback_name' => esc_html__( 'Main Menu', 'foxiz' )
		);
		if ( ! empty( $settings['color_scheme'] ) ) {
			$args['sub_scheme'] = 'light-scheme';
		}
		?>
        <nav id="site-navigation" class="main-menu-wrap template-menu" aria-label="<?php esc_attr_e( 'main menu', 'foxiz-core' ); ?>">
			<?php wp_nav_menu( $args ); ?><?php if ( ! empty( $settings['menu_more'] ) ) {
				foxiz_header_more( array( 'more' => true ) );
			} ?>
        </nav>
		<?php foxiz_elementor_single_sticky_html( $settings );
	}
}

if ( ! function_exists( 'foxiz_elementor_single_sticky_html' ) ) {
	function foxiz_elementor_single_sticky_html( $settings = array() ) {

		if ( ! function_exists( 'foxiz_single_sticky_html' ) || empty( $settings['is_main_menu'] ) ) {
			return false;
		}

		if ( foxiz_get_option( 'single_post_sticky_title' ) && ( is_singular( 'post' ) || is_singular( 'podcast' ) ) && ! foxiz_is_amp() ) {
			foxiz_single_sticky_html();
		}

		return false;
	}
}

if ( ! function_exists( 'foxiz_elementor_social_list' ) ) {
	function foxiz_elementor_social_list() { ?>
        <div class="header-social-list wnav-holder"><?php
			if ( function_exists( 'foxiz_get_social_list' ) ) {
				echo foxiz_get_social_list( foxiz_get_option() );
			}
			?></div>
	<?php }
}

if ( ! function_exists( 'foxiz_elementor_header_search' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false
	 */
	function foxiz_elementor_header_search( $settings = array() ) {

		if ( ! function_exists( 'foxiz_header_search' ) || ! function_exists( 'foxiz_header_search_form' ) ) {
			return false;
		}

		if ( empty( $settings['search_layout'] ) || 'form' !== $settings['search_layout'] ) {
			foxiz_header_search( $settings );
		} else {
			foxiz_header_search_form( $settings );
		}
	}
}

if ( ! function_exists( 'foxiz_elementor_mini_cart' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false
	 */
	function foxiz_elementor_mini_cart( $settings = array() ) {

		if ( ! function_exists( 'foxiz_header_mini_cart_html' ) ) {
			return false;
		}

		foxiz_header_mini_cart_html();
	}
}

if ( ! function_exists( 'foxiz_elementor_sidebar_menu' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false
	 */
	function foxiz_elementor_sidebar_menu( $settings = array() ) {

		if ( empty( $settings['menu'] ) || ! is_nav_menu( $settings['menu'] ) ) {
			return false;
		}

		$classes = 'sidebar-menu';
		$depth   = 4;
		if ( ! empty( $settings['menu_layout'] ) ) {
			$classes .= ' is-horizontal';
			$depth   = 1;
		}

		wp_nav_menu( array(
			'menu'       => $settings['menu'],
			'menu_id'    => false,
			'container'  => '',
			'menu_class' => $classes,
			'depth'      => $depth,
			'echo'       => true
		) );
	}
}

if ( ! function_exists( 'foxiz_elementor_single_category' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false|void
	 */
	function foxiz_elementor_single_category( $settings = array() ) {

		if ( ! function_exists( 'foxiz_get_entry_categories' ) ) {
			return;
		}

		if ( empty( $settings['entry_category'] ) ) {
			$settings['entry_category'] = foxiz_get_option( 'single_post_entry_category' );
		}

		if ( empty( $settings['entry_category'] ) && '-1' === (string) $settings['entry_category'] ) {
			return false;
		}

		$classes = 's-cats';
		$parse   = explode( ',', $settings['entry_category'] );
		if ( ! empty( $parse[0] ) ) {
			$classes .= ' ecat-' . $parse[0];
		}
		if ( ! empty( $parse[1] ) ) {
			$classes .= ' ecat-size-' . $parse[1];
		}
		if ( ! empty( $settings['color_scheme'] ) ) {
			$classes .= ' light-scheme';
		}

		if ( ! empty( $settings['hide_category'] ) ) {
			switch ( $settings['hide_category'] ) {
				case 'mobile' :
					$classes .= ' mobile-hide';
					break;
				case 'tablet' :
					$classes .= ' tablet-hide';
					break;
				case 'all' :
					$classes .= ' mobile-hide tablet-hide';
					break;
			}
		}

		$settings = array( 'entry_category' => true );
		if ( ! empty( $settings['primary_category'] ) && '1' === (string) $settings['primary_category'] ) {
			$settings['is_singular'] = true;
		}
		?>
        <div class="<?php echo esc_attr( $classes ); ?>">
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
				echo '<div class="p-categories"><a href="#" class="p-category">' . esc_html__( 'Dynamic Category', 'foxiz-core' ) . '</a></div>';
			} else {
				echo foxiz_get_entry_categories( $settings );
			}
			?>
        </div>
	<?php }
}

if ( ! function_exists( 'foxiz_elementor_single_featured' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false|void
	 */
	function foxiz_elementor_single_featured( $settings = array() ) {

		if ( ! function_exists( 'foxiz_single_standard_featured' ) ) {
			return false;
		}

		if ( empty( $settings['crop_size'] ) ) {
			$settings['crop_size'] = 'full';
		}

		$classes = 's-feat-outer stemplate-feat';
		if ( ! empty( $settings['caption_line'] ) && '-1' === (string) $settings['caption_line'] ) {
			$classes .= ' is-s-caption';
		}
		?>
        <div class="<?php echo esc_attr( $classes ); ?>">
			<?php
			if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) :
				echo '<div class="s-feat-placeholder"></div>';
				echo '<div class="feat-caption meta-text"><span class="caption-text meta-bold">' . esc_html__( 'This is a example featured caption', 'foxiz-core' ) . '</span></div>';
			else :
				$post_id = get_the_ID();
				$format  = get_post_format( $post_id );
				switch ( $format ) {
					case 'video' :
						foxiz_single_video_embed( $post_id );
						break;
					case 'audio':
						foxiz_single_audio_embed( $post_id );
						break;
					case 'gallery':

						if ( empty( $settings['gallery_layout'] ) ) {
							$settings['gallery_layout'] = 'gallery_1';
						}
						if ( empty( $settings['gallery_crop_size'] ) ) {
							$settings['gallery_crop_size'] = 'full';
						}

						switch ( $settings['gallery_layout'] ) {
							case 'gallery_1' :
								foxiz_single_gallery_slider( $settings['gallery_crop_size'], $post_id );
								break;
							case 'gallery_2' :
								foxiz_single_gallery_carousel( $settings['gallery_crop_size'], $post_id );
								break;
							case 'gallery_3' :
								foxiz_single_gallery_coverflow( $settings['gallery_crop_size'], $post_id );
								break;
						}
						break;
					default:
						foxiz_single_standard_featured( $settings['crop_size'] );
						foxiz_single_featured_caption();
				}
			endif; ?>
        </div>
		<?php
	}
}

if ( ! function_exists( 'foxiz_elementor_custom_field_meta' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false
	 */
	function foxiz_elementor_custom_field_meta( $settings = array() ) {

		if ( empty( $settings['meta_id'] ) ) {
			return false;
		}

		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			$value = esc_html__( 'dynamic meta value', 'foxiz-core' );
		} else {
			$value = get_post_meta( get_the_ID(), trim( $settings['meta_id'] ), true );
		}

		if ( empty( $value ) ) {
			return false;
		}
		if ( empty( $settings['label_position'] ) ) {
			$settings['icon_position'] = 'end';
		}

		if ( empty( $settings['icon_position'] ) ) {
			$settings['icon_position'] = 'begin';
		}

		echo '<span class="cfield-meta">';
		if ( 'begin' === $settings['icon_position'] ) {
			foxiz_elementor_custom_field_icon( $settings );
		}
		if ( 'begin' === $settings['label_position'] ) {
			foxiz_elementor_custom_field_label( $settings );
		}
		echo '<span class="meta-value">' . esc_html( $value ) . '</span>';
		if ( 'end' === $settings['label_position'] ) {
			foxiz_elementor_custom_field_label( $settings );
		}

		if ( 'end' === $settings['icon_position'] ) {
			foxiz_elementor_custom_field_icon( $settings );
		}
		echo '</span>';
	}
}

if ( ! function_exists( 'foxiz_elementor_custom_field_label' ) ) {
	/**
	 * @param $settings
	 *
	 * @return false
	 */
	function foxiz_elementor_custom_field_label( $settings ) {

		if ( empty( $settings['meta_label'] ) ) {
			return false;
		}
		?>
        <span class="meta-tagline"><?php echo esc_html( $settings['meta_label'] ); ?></span>
	<?php }
}

if ( ! function_exists( 'foxiz_elementor_custom_field_icon' ) ) {
	/**
	 * @param $settings
	 *
	 * @return false
	 */
	function foxiz_elementor_custom_field_icon( $settings ) {

		if ( empty( $settings['meta_icon'] ) ) {
			return false;
		}
		?>
        <span class="meta-icon"><?php \Elementor\Icons_Manager::render_icon( $settings['meta_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
	<?php }
}