<?php

namespace foxizElementor\Widgets;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

/**
 * Class
 * @package foxizElementor\Widgets
 */
class Single_Tagline extends Widget_Base {

	public function get_name() {

		return 'foxiz-single-tagline';
	}

	public function get_title() {

		return esc_html__( 'Foxiz - Post Tagline', 'foxiz-core' );
	}

	public function get_icon() {

		return 'eicon-text';
	}

	public function get_categories() {

		return array( 'foxiz_single' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'style_section', array(
				'label' => esc_html__( 'Style', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'title_color',
			array(
				'label'     => esc_html__( 'Tagline Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}}' => '--tagline-fcolor: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'title_dark_color',
			array(
				'label'     => esc_html__( 'Dark Mode - Tagline Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'[data-theme="dark"] {{WRAPPER}}' => '--tagline-fcolor: {{VALUE}};',
				),
			)
		);
		$this->add_responsive_control(
			'title_align',
			array(
				'label'     => esc_html__( 'Alignment', 'foxiz-core' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'    => array(
						'title' => esc_html__( 'Left', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center'  => array(
						'title' => esc_html__( 'Center', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'   => array(
						'title' => esc_html__( 'Right', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-right',
					),
					'justify' => array(
						'title' => esc_html__( 'Justified', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-justify',
					),
				),
				'default'   => '',
				'selectors' => array( '{{WRAPPER}}' => 'text-align: {{VALUE}};' )
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Tagline Font', 'foxiz-core' ),
				'name'     => 'title_font',
				'selector' => '{{WRAPPER}} .s-tagline',
			)
		);
		$this->end_controls_section();
	}

	/**
	 * render layout
	 */
	protected function render() {

		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			echo '<h3 class="s-tagline">' . esc_html__( 'Dynamic post tagline will replaced width the real tagline after your assigned this template', 'foxiz-core' ) . '</h3>';
		} else {
			if ( function_exists( 'foxiz_single_tagline' ) ) {
				foxiz_single_tagline();
			}
		}
	}

}