<?php

namespace foxizElementor\Widgets;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use foxizElementorControl\Options;

/**
 * Class
 * @package foxizElementor\Widgets
 */
class Single_Featured extends Widget_Base {

	public function get_name() {

		return 'foxiz-single-featured';
	}

	public function get_title() {

		return esc_html__( 'Foxiz - Post Featured Image', 'foxiz-core' );
	}

	public function get_icon() {

		return 'eicon-featured-image';
	}

	public function get_categories() {

		return array( 'foxiz_single' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section', array(
				'label' => esc_html__( 'for Standard Format', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'crop_size',
			array(
				'label'       => esc_html__( 'Featured Image Size', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::crop_size(),
				'options'     => Options::crop_size_dropdown(),
				'default'     => '0',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'gallery_section', array(
				'label' => esc_html__( 'for Gallery Format', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'gallery_layout',
			array(
				'label'       => esc_html__( 'Gallery Layout', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => esc_html__( 'Select a layout for the featured gallery.', 'foxiz-core' ),
				'options'     => array(
					'gallery_1' => esc_html__( 'Layout 1 (Slider)', 'foxiz-core' ),
					'gallery_2' => esc_html__( 'Layout 2 (Carousel)', 'foxiz-core' ),
					'gallery_3' => esc_html__( 'Layout 3 (Coverflow)', 'foxiz-core' ),
				),
				'default'     => 'gallery_1',
			)
		);
		$this->add_control(
			'gallery_crop_size',
			array(
				'label'       => esc_html__( 'Gallery Image Size', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::crop_size(),
				'options'     => Options::crop_size_dropdown(),
				'default'     => '0',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'video_section', array(
				'label' => esc_html__( 'for Video Format', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_responsive_control(
			'video_ratio', array(
				'label'     => esc_html__( 'Video Iframe Ratio', 'foxiz-core' ),
				'type'      => Controls_Manager::NUMBER,
				'selectors' => array( '{{WRAPPER}}' => '--video-ratio: {{VALUE}}%;' ),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'audio_section', array(
				'label' => esc_html__( 'for Audio Format', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_responsive_control(
			'audio_ratio', array(
				'label'     => esc_html__( 'Audio Iframe Ratio', 'foxiz-core' ),
				'type'      => Controls_Manager::NUMBER,
				'selectors' => array( '{{WRAPPER}}' => '--audio-ratio: {{VALUE}}%;' ),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'caption_section', array(
				'label' => esc_html__( 'Caption Text', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'caption_color',
			array(
				'label'     => esc_html__( 'Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array( '{{WRAPPER}}' => '--meta-b-fcolor: {{VALUE}};' ),
			)
		);
		$this->add_control(
			'caption_dark_color',
			array(
				'label'     => esc_html__( 'Dark Mode - Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array( '[data-theme="dark"] {{WRAPPER}}' => '--meta-b-fcolor: {{VALUE}};' )
			)
		);
		$this->add_control(
			'caption_align',
			array(
				'label'     => esc_html__( 'Alignment', 'foxiz-core' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'    => array(
						'title' => esc_html__( 'Left', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center'  => array(
						'title' => esc_html__( 'Center', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'   => array(
						'title' => esc_html__( 'Right', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-right',
					),
					'justify' => array(
						'title' => esc_html__( 'Justified', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-justify',
					),
				),
				'default'   => '',
				'selectors' => array( '{{WRAPPER}}' => '--caption-align: {{VALUE}};' )
			)
		);
		$this->add_control(
			'caption_line',
			array(
				'label'   => esc_html__( 'Solid Line', 'foxiz-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => Options::switch_dropdown( false ),
				'default' => '1'
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Caption Font', 'foxiz-core' ),
				'name'     => 'caption_font',
				'selector' => '{{WRAPPER}} .caption-text',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'border_section', array(
				'label' => esc_html__( 'Border Radius', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'box_border',
			array(
				'label'     => esc_html__( 'Border Radius', 'foxiz-core' ),
				'type'      => Controls_Manager::NUMBER,
				'selectors' => array( '{{WRAPPER}}' => '--round-5: {{VALUE}}px;' ),
			)
		);
		$this->end_controls_section();
	}

	/**
	 * render layout
	 */
	protected function render() {

		$settings = $this->get_settings();
		\foxiz_elementor_single_featured( $settings );
	}

}