<?php

namespace foxizElementor\Widgets;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use foxizElementorControl\Options;

/**
 * Class
 * @package foxizElementor\Widgets
 */
class Single_Content extends Widget_Base {

	public function get_name() {

		return 'foxiz-single-content';
	}

	public function get_title() {

		return esc_html__( 'Foxiz - Post Content', 'foxiz-core' );
	}

	public function get_icon() {

		return 'eicon-post-content';
	}

	public function get_categories() {

		return array( 'foxiz_single' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'style_section', array(
				'label' => esc_html__( 'Style', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'single_content_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'Please navigate to "Theme Options > Single Post > Content Area" for further settings.', 'foxiz-core' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Tag/Source/Via Label Font', 'foxiz-core' ),
				'name'     => 'tag_link_font',
				'selector' => '{{WRAPPER}} .blabel',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Tag/Source/Via Links Font', 'foxiz-core' ),
				'name'     => 'tag_label_font',
				'selector' => '{{WRAPPER}} .efoot .h5',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'color_section', array(
				'label' => esc_html__( 'Text Color Scheme', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'color_scheme',
			array(
				'label'        => esc_html__( 'Text Color Scheme', 'foxiz-core' ),
				'type'         => Controls_Manager::SELECT,
				'description'  => Options::color_scheme_description(),
				'options'      => array(
					'default-scheme' => esc_html__( 'Default (Dark Text)', 'foxiz-core' ),
					'light-scheme'   => esc_html__( 'Light Text', 'foxiz-core' )
				),
				'prefix_class' => '',
				'default'      => 'default-scheme',
			)
		);
		$this->end_controls_section();
	}

	/**
	 * render layout
	 */
	protected function render() {

		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			echo '<div class="s-content-placeholder">' . esc_html__( 'Dynamic post content', 'foxiz-core' ) . '</div>';
		} else {
			if ( function_exists( 'foxiz_single_content' ) ) {
				\foxiz_single_content();
			}
		}
	}

}