<?php

namespace foxizElementor\Widgets;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

/**
 * Class
 * @package foxizElementor\Widgets
 */
class Single_Breadcrumb extends Widget_Base {

	public function get_name() {

		return 'foxiz-single-breadcrumb';
	}

	public function get_title() {

		return esc_html__( 'Foxiz - Post Breadcrumb', 'foxiz-core' );
	}

	public function get_icon() {

		return 'eicon-theme-builder';
	}

	public function get_categories() {

		return array( 'foxiz_single' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'style_section', array(
				'label' => esc_html__( 'Style', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'breadcrumb_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'This block requests Breadcrumb NavXT or Yoast Breadcrumb or Rankmath SEO Breadcrumb in oder to work.', 'foxiz-core' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
			)
		);
		$this->add_control(
			'breadcrumb_color',
			array(
				'label'     => esc_html__( 'Breadcrumb Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}}' => '--bcrumb-color: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'dark_breadcrumb_color',
			array(
				'label'     => esc_html__( 'Dark Mode - Breadcrumb Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'[data-theme="dark"] {{WRAPPER}}' => '--bcrumb-color {{VALUE}};',
				),
			)
		);
		$this->add_responsive_control(
			'text_align',
			array(
				'label'     => esc_html__( 'Alignment', 'foxiz-core' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'    => array(
						'title' => esc_html__( 'Left', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center'  => array(
						'title' => esc_html__( 'Center', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'   => array(
						'title' => esc_html__( 'Right', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-right',
					),
					'justify' => array(
						'title' => esc_html__( 'Justified', 'foxiz-core' ),
						'icon'  => 'eicon-text-align-justify',
					),
				),
				'default'   => '',
				'selectors' => array( '{{WRAPPER}}' => 'text-align: {{VALUE}};' )
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Breadcrumb Font', 'foxiz-core' ),
				'name'     => 'breadcrumb_font',
				'selector' => '{{WRAPPER}} .breadcrumb-inner',
			)
		);
		$this->end_controls_section();
	}

	/**
	 * render layout
	 */
	protected function render() {
		echo \foxiz_get_breadcrumb();
	}

}