<?php
/** Don't load directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/** system info */
if ( ! class_exists( 'rbSubPageImport', false ) ) {
	class rbSubPageImport extends RB_ADMIN_SUB_PAGE {

		private static $instance;
		public $demos = array();
		public $demos_path;
		public $demos_url;

		/** get_instance */
		static function get_instance() {
			if ( self::$instance === null ) {
				return new self();
			}

			return self::$instance;
		}

		public function __construct() {
			self::$instance = $this;

			parent::__construct();
			$this->demos_path = apply_filters( 'rb_importer_demos_path', trailingslashit( plugin_dir_path( __FILE__ ) . 'demos' ) );
			$this->demos_url  = apply_filters( 'rb_importer_demos_url', trailingslashit( plugin_dir_url( __FILE__ ) . 'demos' ) );
			$this->demos      = RB_ADMIN_CORE::get_instance()->get_imports();
		}

		/** set sub page */
		public function set_sub_page() {
			$this->page_title = esc_html__( 'Demo Importer', 'foxiz-core' );
			$this->menu_title = esc_html__( 'Demo Importer', 'foxiz-core' );

			$this->menu_slug  = 'rb-demo-importer';
			$this->capability = 'administrator';
		}

		public function get_slug() {
			if ( ! $this->validate() ) {
				return 'admin/templates/validate';
			} else {
				return 'admin/import/template';
			}
		}

		public function get_name() {
			if ( ! $this->validate() ) {
				return 'redirect';
			} else {
				return false;
			}
		}

//		/**
//		 * @param $url
//		 * @param string $method
//		 * @param false $context
//		 * @param null $fields
//		 *
//		 * @return bool
//		 * init file
//		 */
//		public function init_filesystem( $url, $method = '', $context = false, $fields = null ) {
//
//			global $wp_filesystem;
//
//			if ( ! empty( $this->creds ) ) {
//				return true;
//			}
//
//			require_once ABSPATH . '/wp-admin/includes/template.php';
//			require_once ABSPATH . '/wp-includes/pluggable.php';
//			require_once ABSPATH . '/wp-admin/includes/file.php';
//
//			ob_start();
//
//			if ( false === ( $this->creds = request_filesystem_credentials( $url, '', false, $context, null ) ) ) {
//				$this->ftp_form = ob_get_contents();
//				ob_end_clean();
//				return false;
//			}
//
//			if ( ! WP_Filesystem( $this->creds ) ) {
//				request_filesystem_credentials( $url, '', true, $context, null );
//				$this->creds    = array();
//				$this->ftp_form = ob_get_contents();
//				ob_end_clean();
//
//				return false;
//			}
//
//			return true;
//		}

//		public static function load_direct() {
//
//			if ( self::$direct === null ) {
//				require_once ABSPATH . '/wp-admin/includes/class-wp-filesystem-base.php';
//				require_once ABSPATH . '/wp-admin/includes/class-wp-filesystem-direct.php';
//				self::$direct = new WP_Filesystem_Direct( array() );
//			}
//		}
//
//		/** create index */
//		public function create_index() {
//			$this->init_filesystem( wp_nonce_url( '?page=' . $this->menu_slug ) );
//			global $wp_filesystem;
//			$this->filesystem = $wp_filesystem;
//
//			$index_path = trailingslashit( $this->demos_path ) . 'index.php';
//			if ( ! file_exists( $index_path ) ) {
//				if ( isset( $this->ftp_form ) && ! empty( $this->ftp_form ) ) {
//					self::load_direct();
//					self::$direct->put_contents( $index_path, '<?php' . PHP_EOL . '// Silence is golden.', FS_CHMOD_FILE );
//				} else {
//					$this->filesystem->put_contents( $index_path, '<?php' . PHP_EOL . '// Silence is golden.', FS_CHMOD_FILE );
//				}
//			}
//		}

		/**get params */
		public function get_params() {

			/** load importer library */
			require_once plugin_dir_path( __FILE__ ) . 'parts.php';

			$params          = array();
			$imported        = get_option( 'rb_imported_demos' );
			$params['demos'] = $this->demos;
			if ( is_array( $params['demos'] ) && count( $params['demos'] ) ) {
				foreach ( $params['demos'] as $directory => $values ) {
					if ( empty( $params['demos'][ $directory ]['preview'] ) ) {
						$params['demos'][ $directory ]['preview'] = $this->demos_url . $directory . '.jpg';
					}
					if ( is_array( $imported ) && ! empty( $imported[ $directory ] ) ) {
						$params['demos'][ $directory ]['imported'] = $imported[ $directory ];
					} else {
						$params['demos'][ $directory ]['imported'] = 'none';
					}
				}
			}
			$params = apply_filters( 'rb_importer_params', $params );

			return $params;
		}
	}
}