<?php
/** Don't load directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'foxiz_single_footer' ) ) {
	/**
	 * @param false $override
	 *
	 * @return false
	 */
	function foxiz_single_footer( $override = false ) {

		global $wp_query;

		if ( isset( $wp_query->query_vars['rbsnp'] ) ) {
			return false;
		}

		$post_id           = get_the_ID();
		$popular_shortcode = foxiz_get_option( 'single_post_popular_shortcode' );
		$related_shortcode = foxiz_get_option( 'single_post_related_shortcode' );
		$related_section   = foxiz_get_option( 'single_post_related' );

		if ( $override || $related_section ) {

			$related_classes = 'sfoter-sec';
			if ( ! $override ) {
				$related_classes .= ' single-related ';
			}

			$settings = array(
				'uuid'       => 'uuid_r' . $post_id,
				'layout'     => foxiz_get_option( 'single_post_related_layout' ),
				'pagination' => foxiz_get_option( 'single_post_related_pagination' ),
			);

			/** $_query */
			$_query = foxiz_query_related( $settings );
			if ( ! $_query->have_posts() ) {
				return false;
			} ?>
            <aside class="<?php echo esc_attr( $related_classes ); ?>">
				<?php
				if ( 'rb_template' === $related_section && ! empty( $related_shortcode ) ) :
					$GLOBALS['ruby_template_query'] = $_query;
					echo do_shortcode( $related_shortcode );
				else :
					/**  standard layout */
					$related_title = foxiz_get_option( 'single_post_related_blog_heading' );
					if ( empty( $related_title ) ) {
						$related_title = foxiz_html__( 'You Might Also Like', 'foxiz' );
					}
					if ( '-1' !== (string) $related_title ) {
						echo foxiz_get_heading( array(
							'title'    => $related_title,
							'layout'   => foxiz_get_option( 'single_post_related_blog_heading_layout' ),
							'html_tag' => foxiz_get_option( 'single_post_related_blog_heading_tag' ),
						) );
					}
					echo foxiz_get_single_footer_listing( $settings, $_query );
				endif; ?>
            </aside>
			<?php
		}
		if ( ! empty( $popular_shortcode ) && is_singular( 'post' ) && ! $override ) : ?>
            <aside class="single-popular">
				<?php echo do_shortcode( $popular_shortcode ); ?>
            </aside>
		<?php endif;
	}
}

if ( ! function_exists( 'foxiz_get_single_footer_listing' ) ) {
	/**
	 * @param array $settings
	 * @param null $_query
	 *
	 * @return false
	 */
	function foxiz_get_single_footer_listing( $settings = array(), $_query = null ) {

		if ( empty( $settings['layout'] ) ) {
			return false;
		}

		$settings['excerpt_length'] = 0;
		$settings['excerpt']        = 1;

		switch ( $settings['layout'] ) {
			case 'grid_1' :
				$settings['columns'] = 3;
				return foxiz_get_grid_1( $settings, $_query );
			case 'grid_2' :
				$settings['columns'] = 3;
				return foxiz_get_grid_2( $settings, $_query );
			case 'grid_box_1' :
				$settings['columns'] = 3;
				return foxiz_get_grid_box_1( $settings, $_query );
			case 'grid_box_2' :
				$settings['columns'] = 3;
				return foxiz_get_grid_box_2( $settings, $_query );
			default:
				$settings['columns'] = 4;
				return foxiz_get_grid_small_1( $settings, $_query );
		}
	}
}
