<?php
/** Don't load directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'foxiz_podcast_single_metaboxes' ) ) {
	function foxiz_podcast_single_metaboxes() {

		return array(
			'id'         => 'foxiz_post_options',
			'title'      => esc_html__( 'Episode Settings', 'foxiz' ),
			'context'    => 'normal',
			'post_types' => array( 'podcast' ),
			'tabs'       => array(
				array(
					'id'     => 'section-file',
					'title'  => esc_html__( 'Episode Data', 'foxiz' ),
					'icon'   => 'dashicons-media-audio',
					'desc'   => esc_html__( 'Upload audio episode files as MP3 or M4A, or paste the file URL.', 'foxiz' ),
					'fields' => array(
						array(
							'id'   => 'audio_hosted',
							'name' => esc_html__( 'Self-Hosted File', 'foxiz' ),
							'desc' => esc_html__( 'Upload your audio file, support: mp3, ogg, wma, m4a, wav files.', 'foxiz' ),
							'type' => 'file'
						),
						array(
							'id'   => 'audio_url',
							'name' => esc_html__( 'Audio URL', 'foxiz' ),
							'desc' => esc_html__( 'Input your audio URL, support: SoundCloud, MixCloud.', 'foxiz' ),
							'type' => 'text'
						),
						array(
							'id'   => 'audio_embed',
							'name' => esc_html__( 'Iframe Embed Code', 'foxiz' ),
							'desc' => esc_html__( 'Input iframe embed code if WordPress cannot support your audio URL.', 'foxiz' ),
							'type' => 'textarea'
						),
						array(
							'id'      => 'audio_autoplay',
							'name'    => esc_html__( 'Autoplay Audio', 'foxiz' ),
							'desc'    => esc_html__( 'Enable or disable autoplay audio for this episode.', 'foxiz' ),
							'type'    => 'select',
							'options' => array(
								'default' => esc_html__( '- Default -', 'foxiz' ),
								'1'       => esc_html__( 'Enable', 'foxiz' ),
								'-1'      => esc_html__( 'Disable', 'foxiz' )
							),
							'default' => 'default'
						),
					)
				),
				array(
					'id'     => 'section-tagline',
					'title'  => esc_html__( 'Tagline', 'foxiz' ),
					'icon'   => 'dashicons-edit-large',
					'fields' => array(
						array(
							'id'      => 'tagline',
							'name'    => esc_html__( 'Tagline', 'foxiz' ),
							'desc'    => esc_html__( 'Input a tagline for this episode.', 'foxiz' ),
							'info'    => esc_html__( 'It will display under the episode title.', 'foxiz' ),
							'type'    => 'textarea',
							'default' => ''
						),
						array(
							'id'      => 'tagline_tag',
							'name'    => esc_html__( 'Tagline HTML Tag', 'foxiz' ),
							'desc'    => esc_html__( 'Select a HTML tag for this tagline.', 'foxiz' ),
							'type'    => 'select',
							'options' => array(
								'0'    => esc_html__( '- Default -', 'foxiz' ),
								'h2'   => esc_html__( 'H2', 'foxiz' ),
								'h3'   => esc_html__( 'H3', 'foxiz' ),
								'h4'   => esc_html__( 'H4', 'foxiz' ),
								'h5'   => esc_html__( 'H5', 'foxiz' ),
								'h6'   => esc_html__( 'H6', 'foxiz' ),
								'p'    => esc_html__( 'p', 'foxiz' ),
								'span' => esc_html__( 'span', 'foxiz' )
							),
							'default' => '0'
						)
					)
				),
				array(
					'id'     => 'section-meta',
					'title'  => esc_html__( 'Episode Meta', 'foxiz' ),
					'icon'   => 'dashicons-database',
					'fields' => array(
						array(
							'id'          => 'post_index',
							'name'        => esc_html__( 'Episode Index', 'foxiz' ),
							'desc'        => esc_html__( 'The index of this episode file.', 'foxiz' ),
							'placeholder' => 'Episode 1',
							'type'        => 'text'
						),
						array(
							'id'          => 'duration',
							'name'        => esc_html__( 'Duration', 'foxiz' ),
							'desc'        => esc_html__( 'Duration of this episode file. This setting will also apply to SEO markup data.', 'foxiz' ),
							'info'        => esc_html__( 'Ensure the date format is HH:MM:SS', 'foxiz' ),
							'placeholder' => '01:10:30',
							'type'        => 'text'
						),
						array(
							'id'      => 'featured_caption',
							'name'    => esc_html__( 'Caption Text', 'foxiz' ),
							'desc'    => esc_html__( 'Input caption text for the featured image.', 'foxiz' ),
							'type'    => 'textarea',
							'default' => ''
						),
						array(
							'id'      => 'featured_attribution',
							'name'    => esc_html__( 'Attribution', 'foxiz' ),
							'desc'    => esc_html__( 'Input an attribution for the featured image.', 'foxiz' ),
							'type'    => 'text',
							'default' => ''
						)
					)
				),
				array(
					'id'     => 'section-socials',
					'title'  => esc_html__( 'Media Socials', 'foxiz' ),
					'icon'   => 'dashicons-admin-links',
					'fields' => array(
						array(
							'id'          => 'listen_on_apple',
							'name'        => esc_html__( 'Listen on Apple Podcast', 'foxiz' ),
							'desc'        => esc_html__( 'Add an Apple podcast link for this episode.', 'foxiz' ),
							'placeholder' => 'https://podcasts.apple.com...',
							'type'        => 'textarea'
						),
						array(
							'id'          => 'listen_on_spotify',
							'name'        => esc_html__( 'Listen on Spotify', 'foxiz' ),
							'desc'        => esc_html__( 'Add a Spotify link for this episode.', 'foxiz' ),
							'placeholder' => 'https://open.spotify.com/...',
							'type'        => 'textarea'
						),
						array(
							'id'          => 'listen_on_soundcloud',
							'name'        => esc_html__( 'Listen on Soundcloud', 'foxiz' ),
							'desc'        => esc_html__( 'Add a Soundcloud link for this episode.', 'foxiz' ),
							'placeholder' => 'https://soundcloud.com/...',
							'type'        => 'textarea'
						),
						array(
							'id'          => 'listen_on_google',
							'name'        => esc_html__( 'Listen on Google Podcast', 'foxiz' ),
							'desc'        => esc_html__( 'Add a google podcast link for this episode.', 'foxiz' ),
							'placeholder' => 'https://podcasts.google.com/...',
							'type'        => 'textarea'
						),
						array(
							'id'     => 'listen_on',
							'name'   => esc_html__( 'More Social Podcasts', 'foxiz' ),
							'desc'   => esc_html__( 'Add this episode links on other social media podcasts.', 'foxiz' ),
							'type'   => 'group',
							'button' => '+ Add Link',
							'fields' => array(
								array(
									'name'        => esc_html__( 'Social Name', 'foxiz' ),
									'id'          => 'label',
									'placeholder' => 'Spotify',
									'default'     => '',
								),
								array(
									'name'        => esc_html__( 'Icon Classname', 'foxiz' ),
									'placeholder' => 'rbi-spotify',
									'id'          => 'icon',
									'default'     => '',
								),
								array(
									'name'        => esc_html__( 'Episode URL', 'foxiz' ),
									'placeholder' => 'https://open.spotify.com/episode...',
									'id'          => 'url',
									'default'     => '',
								)
							)
						)
					)
				),
				array(
					'id'     => 'section-layout',
					'title'  => esc_html__( 'Layout', 'foxiz' ),
					'desc'   => esc_html__( 'The setting below will take priority over other settings in "Theme Options > Ruby Podcast > Episode".', 'foxiz' ),
					'icon'   => 'dashicons-menu',
					'fields' => array(
						array(
							'id'      => 'layout',
							'name'    => esc_html__( 'Episode Layout', 'foxiz' ),
							'desc'    => esc_html__( 'Select a layout for this single episode.', 'foxiz' ),
							'info'    => esc_html__( 'This setting will override on the Theme Option setting.', 'foxiz' ),
							'type'    => 'image_select',
							'class'   => 'big',
							'options' => array(
								'default' => array(
									'img'   => foxiz_get_asset_image( 'default.png' ),
									'title' => esc_html__( '- Default -', 'foxiz' )
								),
								'1'       => array(
									'img'   => foxiz_get_asset_image( 'single-6.png' ),
									'title' => esc_html__( 'Layout 1', 'foxiz' )
								),
								'2'       => array(
									'img'   => foxiz_get_asset_image( 'single-7.png' ),
									'title' => esc_html__( 'Layout 2', 'foxiz' )
								),
							),
							'default' => 'default'
						)
					)
				),
				array(
					'id'     => 'section-sidebar',
					'title'  => esc_html__( 'Sidebar Area', 'foxiz' ),
					'desc'   => esc_html__( 'The settings below will take priority over other settings in "Theme Options > Ruby Podcast > Episode".', 'foxiz' ),
					'icon'   => 'dashicons-align-pull-right',
					'fields' => array(
						array(
							'id'      => 'sidebar_position',
							'name'    => esc_html__( 'Sidebar Position', 'foxiz' ),
							'desc'    => esc_html__( 'Select a position for this episode sidebar.', 'foxiz' ),
							'class'   => 'sidebar-select',
							'type'    => 'image_select',
							'options' => foxiz_config_sidebar_position( true, true ),
							'default' => 'default'
						),
						array(
							'id'      => 'sidebar_name',
							'name'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
							'desc'    => esc_html__( 'Assign a custom sidebar for this episode.', 'foxiz' ),
							'type'    => 'select',
							'options' => foxiz_config_sidebar_name(),
							'default' => 'default'
						)
					)
				),
				array(
					'id'     => 'section-header',
					'title'  => 'Site Header',
					'icon'   => 'dashicons-heading',
					'fields' => array(
						array(
							'id'      => 'header_style',
							'name'    => esc_html__( 'Header Style', 'foxiz' ),
							'desc'    => esc_html__( 'Select a site header for this episode.', 'foxiz' ),
							'type'    => 'select',
							'options' => foxiz_config_header_style( true ),
							'default' => 'default'
						),
						array(
							'id'      => 'nav_style',
							'type'    => 'select',
							'name'    => esc_html__( 'Navigation Bar Style', 'foxiz' ),
							'desc'    => esc_html__( 'Select navigation bar style for the site header of this episode.', 'foxiz' ),
							'info'    => esc_html__( 'This setting will apply only to pre-defined headers: 1, 2, 3 and 5.', 'foxiz' ),
							'options' => array(
								'default'  => esc_html__( '- Default -', 'foxiz' ),
								'shadow'   => esc_html__( 'Shadow', 'foxiz' ),
								'border'   => esc_html__( 'Bottom Border', 'foxiz' ),
								'd-border' => esc_html__( 'Dark Bottom Border', 'foxiz' ),
								'none'     => esc_html__( 'None', 'foxiz' )
							),
							'default' => 'default'
						),
						array(
							'id'          => 'header_template',
							'name'        => esc_html__( 'Template Shortcode', 'foxiz' ),
							'desc'        => esc_html__( 'Input a Ruby Template shortcode for displaying as the website header for this page.', 'foxiz' ),
							'info'        => esc_html__( 'This setting will override on the "Header style" setting.', 'foxiz' ),
							'placeholder' => '[Ruby_E_Template id="1"]',
							'type'        => 'textarea',
							'default'     => ''
						)
					)
				)
			)
		);
	}
}
