<?php
/** Don't load directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Foxiz_Font', false ) ) {
	class Foxiz_Font {

		private static $instance;
		public $gfonts = false;
		public $settings = array();

		public static function get_instance() {

			if ( self::$instance === null ) {
				return new self();
			}

			return self::$instance;
		}

		public function __construct() {

			self::$instance = $this;

			$this->gfonts   = $this->get_gfonts();
			$this->settings = get_option( FOXIZ_TOS_ID, array() );

			add_filter( 'foxiz_default_fonts', array( $this, 'default_fonts' ) );
		}

		/**
		 * @param $pre_fonts
		 *
		 * @return array
		 */
		public function default_fonts( $pre_fonts ) {

			if ( ! empty( $this->settings['disable_default_fonts'] ) ) {
				return $pre_fonts;
			}

			return array_merge( $pre_fonts, array(
				[
					'font-family' => 'Oxygen',
					'font-style'  => '400,700',
				],
				[
					'font-family' => 'Encode Sans Condensed',
					'font-style'  => '400,500,600,700,800',
				],
			) );
		}

		/**
		 * @return false|mixed
		 */
		public function get_gfonts() {

			if ( defined( 'FOXIZ_CORE_PATH' ) ) {
				$gfont_file = FOXIZ_CORE_PATH . 'lib/redux-framework/inc/fields/typography/googlefonts.php';
				if ( file_exists( $gfont_file ) ) {
					return include $gfont_file;
				}
			}

			return false;
		}

		/**
		 * @param $font_family
		 *
		 * @return false|string
		 */
		public function get_all_styles( $font_family ) {

			$styles  = array();
			$exclude = array( '100', '200', '300', '100i', '200i', '300i' );
			if ( empty( $font_family ) || ! isset( $this->gfonts[ $font_family ] ) ) {
				return false;
			}
			$gfont = $this->gfonts[ $font_family ];
			if ( is_array( $gfont['variants'] ) ) {
				foreach ( $gfont['variants'] as $variant ) {
					if ( ! isset( $variant['id'] ) || ! in_array( $variant['id'], $exclude ) ) {
						array_push( $styles, $variant['id'] );
					}
				}
			}

			return implode( ',', $styles );
		}

		/** get google font URLs */
		function get_font_url() {

			$pre_fonts = array();
			$fonts     = array();
			$subsets   = array();
			$link      = '';

			foreach ( $this->settings as $id => $field ) {

				if ( ! empty( $field['subsets'] ) && $field['subsets'] === 'adobe' ) {
					continue;
				}

				if ( ! empty( $field['font-family'] ) ) {

					if ( ! isset( $field['font-style'] ) ) {
						$field['font-style'] = '';
					}
					if ( 'font_body' === $id ) {
						$field['font-weight'] = '';
						$field['font-style']  = $this->get_all_styles( $field['font-family'] );
					}

					if ( ! empty( $field['font-weight'] ) ) {
						$field['font-style'] = $field['font-weight'] . $field['font-style'];
					}
					array_push( $pre_fonts, $field );
				}
			}

			$pre_fonts = apply_filters( 'foxiz_default_fonts', $pre_fonts );

			foreach ( $pre_fonts as $field ) {

				$field['font-family'] = str_replace( ' ', '+', $field['font-family'] );
				$styles               = explode( ',', $field['font-style'] );

				if ( ! isset( $fonts[ $field['font-family'] ] ) ) {
					$fonts[ $field['font-family'] ]               = $field;
					$fonts[ $field['font-family'] ]['font-style'] = array();
				}

				$fonts[ $field['font-family'] ]['font-style'] = array_merge( $fonts[ $field['font-family'] ]['font-style'], $styles );
			}

			foreach ( $fonts as $family => $font ) {
				if ( ! empty( $link ) ) {
					$link .= "%7C";
				}
				$link .= $family;

				if ( ! empty( $font['font-style'] ) && is_array( $font['font-style'] ) ) {
					$link               .= ':';
					$font['font-style'] = array_unique( $font['font-style'] );
					$link               .= implode( ',', $font['font-style'] );
				}

				if ( ! empty( $font['subset'] ) ) {
					foreach ( $font['subset'] as $subset ) {
						if ( ! in_array( $subset, $subsets ) ) {
							array_push( $subsets, $subset );
						}
					}
				}
			}

			if ( ! empty( $subsets ) ) {
				$link .= "&subset=" . implode( ',', $subsets );
			}
			$link .= "&display=swap";

			return '//fonts.googleapis.com/css?family=' . str_replace( '|', '%7C', $link );
		}
	}
}
