<?php
if ( ! function_exists( 'foxiz_wc_plugin_status_info' ) ) {
	/**
	 * @param string $id
	 *
	 * @return array|null
	 */
	function foxiz_wc_plugin_status_info( $id = 'wc_shop_info' ) {

		if ( ! class_exists( 'WooCommerce' ) ) {
			return array(
				'id'    => $id,
				'type'  => 'info',
				'style' => 'warning',
				'desc'  => html_entity_decode( esc_html__( 'Woocommerce plugin not found! The settings below request the <a href=\'https://wordpress.org/plugins/woocommerce/\'>Woocommerce</a> plugin to work.', 'foxiz' ) ),
			);
		}

		return null;
	}
}

if ( ! function_exists( 'foxiz_register_options_woocommerce' ) ) {
	function foxiz_register_options_woocommerce() {

		return array(
			'id'    => 'foxiz_config_section_woocommerce',
			'title' => esc_html__( 'WooCommerce', 'foxiz' ),
			'desc'  => esc_html__( 'Select options for the shop.', 'foxiz' ),
			'icon'  => 'el el-shopping-cart'
		);
	}
}

/**
 * @return array
 * single product
 */
if ( ! function_exists( 'foxiz_register_options_wc_page' ) ) {
	function foxiz_register_options_wc_page() {

		return array(
			'id'         => 'foxiz_config_section_wc_page',
			'title'      => esc_html__( 'Shop & Archives', 'foxiz' ),
			'desc'       => esc_html__( 'Select options for the shop and archive and single product pages.', 'foxiz' ),
			'icon'       => 'el el-folder-open',
			'subsection' => true,
			'fields'     => array(
				foxiz_wc_plugin_status_info(),
				array(
					'id'     => 'section_start_wc_shop',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Shop Page', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'          => 'wc_shop_template',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Header Template Shortcode', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input your template shortcode you would like to use Elementor builder to create a featured section at the top of shop page.', 'foxiz' ),
					'placeholder' => '[Ruby_E_Template id="1"]',
					'rows'        => '2',
					'default'     => ''
				),
				array(
					'id'       => 'wc_shop_posts_per_page',
					'type'     => 'text',
					'class'    => 'small-text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Products per Page', 'foxiz' ),
					'subtitle' => esc_html__( 'Select number of products per page, leave blank if you want to set as Settings default.', 'foxiz' ),
					'default'  => false
				),
				array(
					'id'       => 'wc_shop_sidebar_position',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Shop Sidebar Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select sidebar position for the shop page if you enabled the sidebar.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_position( false ),
					'default'  => 'none'
				),
				array(
					'id'       => 'wc_shop_sidebar_name',
					'type'     => 'select',
					'title'    => esc_html__( 'Shop Sidebar Name', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar for the shop page if you enabled the sidebar.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_name(),
					'default'  => 'foxiz_sidebar_default',
				),
				array(
					'id'     => 'section_end_wc_shop',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_wc_archive',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Category & Archives', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'       => 'wc_archive_sidebar_position',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Archive Sidebar Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar position for product category and archive pages if you enabled the sidebar.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_position( false ),
					'default'  => 'none'
				),
				array(
					'id'       => 'wc_archive_sidebar_name',
					'type'     => 'select',
					'title'    => esc_html__( 'Archive Sidebar Name', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar for product category and archive pages if you enabled the sidebar.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_name(),
					'default'  => 'foxiz_sidebar_default',
				),
				array(
					'id'     => 'section_end_wc_archive',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false
				)
			)
		);
	}
}

/**
 * @return array
 * styling
 */
if ( ! function_exists( 'foxiz_register_options_wc_style' ) ) {
	function foxiz_register_options_wc_style() {

		return array(
			'id'         => 'foxiz_config_section_wc_style',
			'title'      => esc_html__( 'General', 'foxiz' ),
			'desc'       => esc_html__( 'Select styles and layout for the product listing.', 'foxiz' ),
			'icon'       => 'el el-adjust-alt',
			'subsection' => true,
			'fields'     => array(
				foxiz_wc_plugin_status_info( 'wc_page_info' ),
				array(
					'id'    => 'info_product_block',
					'type'  => 'info',
					'style' => 'success',
					'desc'  => esc_html__( 'You can use "Foxiz - Grid Products" to display products on the homepage and other pages. This block also supports individual responsive settings.', 'foxiz' ),
				),
				array(
					'id'     => 'section_start_wc_boxed',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Boxed', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'       => 'wc_box_style',
					'title'    => esc_html__( 'Box Style', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a box style for the product listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_box_style( true ),
					'default'  => '0'
				),
				array(
					'id'          => 'wc_box_color',
					'title'       => esc_html__( 'Box Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the background or border style.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false
				),
				array(
					'id'          => 'wc_dark_box_color',
					'title'       => esc_html__( 'Dark Mode - Box Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the background or border style in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false
				),
				array(
					'id'     => 'section_end_wc_boxed',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'       => 'section_start_wc_responsive',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Responsive List/Grid & Centering', 'foxiz' ),
					'subtitle' => esc_html__( 'This setting will apply only to main product loop of the standard WooCommerce pages such as shop, category and archives.', 'foxiz' ),
					'indent'   => true
				),
				array(
					'id'       => 'wc_responsive_list',
					'type'     => 'switch',
					'title'    => esc_html__( 'Mobile List Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Display product list in the gird layout on mobile devices.', 'foxiz' ),
					'default'  => true
				),
				array(
					'id'       => 'wc_centered',
					'type'     => 'switch',
					'title'    => esc_html__( 'Centering Products', 'foxiz' ),
					'subtitle' => esc_html__( 'Center the product title and meta in the listing.', 'foxiz' ),
					'default'  => false
				),
				array(
					'id'     => 'section_end_wc_responsive',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_wc_sale_style',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Sale Label', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'       => 'wc_sale_percent',
					'type'     => 'switch',
					'title'    => esc_html__( 'Percentage Saved', 'foxiz' ),
					'subtitle' => esc_html__( 'Display Percentage saved on WooCommerce sale products', 'foxiz' ),
					'default'  => true
				),
				array(
					'id'          => 'wc_sale_text',
					'title'       => esc_html__( 'Text Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a text color value for the sale icon.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'          => 'wc_sale_color',
					'title'       => esc_html__( 'Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background color value for the sale icon.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'     => 'section_end_wc_sale_style',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_wc_price',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Price', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'          => 'wc_price_color',
					'title'       => esc_html__( 'Price Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color value for the product price.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color'
				),
				array(
					'id'          => 'wc_dark_price_color',
					'title'       => esc_html__( 'Dark Mode - Price Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color value for the product price in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color'
				),
				array(
					'id'     => 'section_end_wc_price',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_wc_review',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Review', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'          => 'wc_star_color',
					'title'       => esc_html__( 'Review Start Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color value for the stars review.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color'
				),
				array(
					'id'          => 'wc_dark_star_color',
					'title'       => esc_html__( 'Dark Mode - Review Start Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color value for the stars review in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color'
				),
				array(
					'id'     => 'section_end_wc_review',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'       => 'section_start_wc_add_to_cart',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Add to Cart', 'foxiz' ),
					'subtitle' => esc_html__( 'The Visible when Hovering layout is only for the standard (none boxed) grid on the desktop.', 'foxiz' ),
					'indent'   => true
				),
				array(
					'id'       => 'wc_add_cart_layout',
					'title'    => esc_html__( 'Button Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a layout for the add to cart button.', 'foxiz' ),
					'type'     => 'select',
					'options'  => array(
						'0'       => esc_html__( 'Visible when Hovering', 'foxiz' ),
						'visible' => esc_html__( 'Visible', 'foxiz' ),
					),
					'default'  => '0'
				),
				array(
					'id'       => 'wc_add_cart_style',
					'title'    => esc_html__( 'Button Style', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a style for the add to cart button.', 'foxiz' ),
					'type'     => 'select',
					'options'  => array(
						'inline'   => esc_html__( '- Default -', 'foxiz' ),
						'fw'       => esc_html__( 'Fullwidth', 'foxiz' ),
						'b-inline' => esc_html__( 'Inline with Border', 'foxiz' ),
						'b-fw'     => esc_html__( 'Fullwidth with Border', 'foxiz' )
					),
					'default'  => 'inline'
				),
				array(
					'id'          => 'wc_add_cart_text',
					'title'       => esc_html__( 'Text & Border Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a text color for the "Add to Cart" button.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'          => 'wc_add_cart_color',
					'title'       => esc_html__( 'Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background color for the "Add to Cart" button.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'          => 'wc_dark_add_cart_text',
					'title'       => esc_html__( 'Dark Mode - Text & Border Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a text color for the "Add to Cart" button in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
					'default'     => '#fff',
				),
				array(
					'id'          => 'wc_dark_add_cart_color',
					'title'       => esc_html__( 'Dark Mode - Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background color for the "Add to Cart" button in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'       => 'wc_add_cart_border',
					'title'    => esc_html__( 'Border Radius', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a custom border radius value for "Add to Cart" button.', 'foxiz' ),
					'type'     => 'text',
					'validate' => 'numeric',
				),
				array(
					'id'     => 'section_end_wc_add_to_cart',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_wc_add_popup',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Add to Cart Notification', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'       => 'wc_add_cart_popup',
					'title'    => esc_html__( 'Popup Notification', 'foxiz' ),
					'subtitle' => esc_html__( 'Show a popup notification at the bottom when a product is added to the cart.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => true
				),
				array(
					'id'     => 'section_end_wc_add_popup',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false
				),
			)
		);
	}
}

/**
 * @return array
 * styling
 */
if ( ! function_exists( 'foxiz_register_options_wc_single' ) ) {
	function foxiz_register_options_wc_single() {

		return array(
			'id'         => 'foxiz_config_section_wc_single',
			'title'      => esc_html__( 'Single Product', 'foxiz' ),
			'desc'       => esc_html__( 'Select settings for the single product page.', 'foxiz' ),
			'icon'       => 'el el-shopping-cart',
			'subsection' => true,
			'fields'     => array(
				foxiz_wc_plugin_status_info( 'wc_page_info' ),
				array(
					'id'     => 'section_start_wc_single_style',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Group Product Type', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'       => 'wc_group_thumbnail',
					'type'     => 'switch',
					'title'    => esc_html__( 'Group Product Images', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the group product featured images.', 'foxiz' ),
					'default'  => true
				),
				array(
					'id'     => 'section_end_wc_single_style',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_wc_single_section',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Footer Sections', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'       => 'wc_box_review',
					'type'     => 'switch',
					'title'    => esc_html__( 'Show Review Box', 'foxiz' ),
					'subtitle' => esc_html__( 'enable or disable the review box in the single product page.', 'foxiz' ),
					'default'  => true
				),
				array(
					'id'       => 'wc_related_posts_per_page',
					'type'     => 'text',
					'class'    => 'small-text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Total Related Products', 'foxiz' ),
					'subtitle' => esc_html__( 'Select total related product to show at once. leave blank if you want to set as default.', 'foxiz' ),
					'default'  => '4'
				),
				array(
					'id'     => 'section_end_wc_single_section',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false
				)
			)
		);
	}
}

if ( ! function_exists( 'foxiz_register_options_wc_typo' ) ) {
	function foxiz_register_options_wc_typo() {

		return array(
			'id'         => 'foxiz_config_section_wc_typography',
			'title'      => esc_html__( 'Typography', 'foxiz' ),
			'desc'       => esc_html__( 'Select font values for your shop.', 'foxiz' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'fields'     => array(
				foxiz_wc_plugin_status_info( 'wc_page_info' ),

				array(
					'id'     => 'section_start_wc_product_font',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Product Title', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'             => 'font_product',
					'type'           => 'typography',
					'title'          => esc_html__( 'Product Title Font', 'foxiz' ),
					'subtitle'       => esc_html__( 'Select a custom font for the product listing title.', 'foxiz' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'font-size'      => true,
					'units'          => 'px',
					'default'        => array()
				),
				array(
					'id'       => 'font_product_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Tablet Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (px) for product listing title on tablet devices (max screen width: 1024px), Leave this option blank to set the default value.', 'foxiz' ),
				),
				array(
					'id'       => 'font_product_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Mobile Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (px) for the product listing title on mobile devices (max screen width: 767px), Leave this option blank to set the default value.', 'foxiz' ),
				),
				array(
					'id'     => 'section_end_wc_product_font',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false
				),
				array(
					'id'     => 'section_end_wc_product_font',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false
				),
				array(
					'id'       => 'section_start_wc_single_font',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Single Title', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings below will apply to the single product.', 'foxiz' ),
					'indent'   => true
				),
				array(
					'id'       => 'font_sproduct_size',
					'type'     => 'text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (px) for the single product title.', 'foxiz' ),
				),
				array(
					'id'       => 'font_sproduct_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Tablet Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (px) for the single product title on tablet devices (max screen width: 1024px), Leave this option blank to set the default value.', 'foxiz' ),
				),
				array(
					'id'       => 'font_sproduct_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Mobile Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (px) for the single product title on mobile devices (max screen width: 767px), Leave this option blank to set the default value.', 'foxiz' ),
				),
				array(
					'id'     => 'section_end_wc_single_font',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'       => 'section_start_wc_price_font',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Price Font', 'foxiz' ),
					'subtitle' => esc_html__( 'The font size values will apply only to the loop listing.', 'foxiz' ),
					'indent'   => true
				),
				array(
					'id'             => 'font_price',
					'type'           => 'typography',
					'title'          => esc_html__( 'Price Font', 'foxiz' ),
					'subtitle'       => esc_html__( 'Select a custom font for the product price.', 'foxiz' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'font-size'      => true,
					'units'          => 'px',
					'default'        => array()
				),
				array(
					'id'       => 'font_price_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Tablet Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (px) for the price title on tablet devices.', 'foxiz' ),
				),
				array(
					'id'       => 'font_price_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Mobile Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (px) for the price on mobile devices.', 'foxiz' ),
				),
				array(
					'id'     => 'section_end_wc_price_font',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false
				),
			)
		);
	}
}