<?php

namespace foxizElementor\Widgets;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use foxizElementorControl\Options;

/**
 * Class
 * @package foxizElementor\Widgets
 */
class Single_Meta_Bar extends Widget_Base {

	public function get_name() {

		return 'foxiz-single-meta-bar';
	}

	public function get_title() {

		return esc_html__( 'Foxiz - Post Meta Bar', 'foxiz-core' );
	}

	public function get_icon() {

		return 'eicon-meta-data';
	}

	public function get_categories() {

		return array( 'foxiz_single' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'style_section', array(
				'label' => esc_html__( 'Style', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'meta_bar_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'Please navigate to "Theme Options > Single Post > Entry Meta" for further settings.', 'foxiz-core' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
			)
		);
		$this->add_control(
			'meta_font_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'Recommended: use same font family for meta and meta bold settings.', 'foxiz-core' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
			)
		);
		$this->add_responsive_control(
			'big_avatar_size', array(
				'label'       => esc_html__( 'Big Avatar Size', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'placeholder' => '60',
				'selectors'   => array( '{{WRAPPER}} .smeta-in > .meta-avatar img' => 'width: {{VALUE}}px;height: {{VALUE}}px;' ),
			)
		);
		$this->add_control(
			'center_meta',
			array(
				'label'        => esc_html__( 'Meta Align', 'foxiz-core' ),
				'type'         => Controls_Manager::SELECT,
				'description'  => esc_html__( 'Select an align style for the entry meta bar on desktop devices.', 'foxiz-core' ),
				'options'      => array(
					'default-meta'  => esc_html__( '- Default -', 'foxiz-core' ),
					'centered-meta' => esc_html__( 'Center', 'foxiz-core' ),
					'wrap-meta'     => esc_html__( 'Wrap Share Bar', 'foxiz-core' ),
					'center-w-meta' => esc_html__( 'Center, Wrap Share Bar', 'foxiz-core' )
				),
				'prefix_class' => '',
				'default'      => 'default-meta',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Default Meta Font', 'foxiz-core' ),
				'name'     => 'meta_font',
				'selector' => '{{WRAPPER}} .is-meta, {{WRAPPER}} .meta-text',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Bold Meta Font', 'foxiz-core' ),
				'name'     => 'bold_meta_font',
				'selector' => '{{WRAPPER}} .meta-author, {{WRAPPER}} .meta-bold',
			)
		);
		$this->add_responsive_control(
			'share_size', array(
				'label'       => esc_html__( 'Share Icons Size', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'placeholder' => '16',
				'selectors'   => array( '{{WRAPPER}} .t-shared-sec .share-action' => 'font-size: {{VALUE}}px;' ),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'color_section', array(
				'label' => esc_html__( 'Text Color Scheme', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'color_scheme',
			array(
				'label'        => esc_html__( 'Text Color Scheme', 'foxiz-core' ),
				'type'         => Controls_Manager::SELECT,
				'description'  => Options::color_scheme_description(),
				'options'      => array(
					'default-scheme' => esc_html__( 'Default (Dark Text)', 'foxiz-core' ),
					'light-scheme'   => esc_html__( 'Light Text', 'foxiz-core' )
				),
				'prefix_class' => '',
				'default'      => 'default-scheme',
			)
		);
		$this->end_controls_section();
	}

	/**
	 * render layout
	 */
	protected function render() {

		if ( function_exists( 'foxiz_single_header_meta' ) ) {
			\foxiz_single_header_meta();
		}
	}
}