<?php

namespace foxizElementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use foxizElementorControl\Options;

class Product_Grid extends Widget_Base {

	public function get_name() {

		return 'foxiz-product-grid';
	}

	public function get_title() {

		return esc_html__( 'Foxiz - Grid Products', 'foxiz-core' );
	}

	public function get_icon() {

		return 'eicon-products';
	}

	public function get_categories() {

		return array( 'foxiz-flex' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'query_filters', array(
				'label' => esc_html__( 'Query Settings', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_control(
			'shortcode_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => html_entity_decode( esc_html__( 'You can refer shortcodes: <a target="_blank" rel="nofollow" href="https://woocommerce.com/document/woocommerce-shortcodes/">Click here</a>', 'foxiz-core' ) ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
			)
		);
		$this->add_control(
			'columns_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'Foxiz allows you to manage the responsive grid columns via Layout > Columns. Don\'t need to add columns params.', 'foxiz-core' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
			)
		);
		$this->add_control(
			'shortcode', array(
				'label'       => esc_html__( 'WooCommerce Shortcodes', 'foxiz-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => '[products limit="4" orderby="popularity" on_sale="true" offset="0"]',
				'description' => esc_html__( 'To ensure the flexibility, Foxiz allows you to use the WooCommerce Shortcodes to filter any products to show.', 'foxiz-core' ),
				'default'     => '[products limit="4"]'
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'entry_category_section', array(
				'label' => esc_html__( 'Entry Category', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'category_meta',
			array(
				'label'        => esc_html__( 'Entry Category', 'foxiz-core' ),
				'type'         => Controls_Manager::SELECT,
				'description'  => esc_html__( 'Show or hide the product categories meta.' ),
				'options'      => array(
					'0'     => esc_html__( 'Show', 'foxiz-core' ),
					'hide'  => esc_html__( 'Hide', 'foxiz-core' ),
					'mhide' => esc_html__( 'Hide on Mobile', 'foxiz-core' ),
				),
				'prefix_class' => 'pcat-',
				'default'      => '0',
			)
		);
		$this->add_control(
			'category_color', array(
				'label'       => esc_html__( 'Entry Category Color', 'foxiz-core' ),
				'type'        => Controls_Manager::COLOR,
				'description' => esc_html__( 'Select a color for the entry category.', 'foxiz-core' ),
				'selectors'   => array( '{{WRAPPER}}' => '--product-cat-color: {{VALUE}};' ),
			)
		);
		$this->add_control(
			'dark_category_color', array(
				'label'       => esc_html__( 'Dark Mode - Entry Category Color', 'foxiz-core' ),
				'type'        => Controls_Manager::COLOR,
				'description' => esc_html__( 'Select a color for the entry category in dark mode.', 'foxiz-core' ),
				'selectors'   => array( '[data-theme="dark"] {{WRAPPER}}' => '--product-cat-color: {{VALUE}};' ),
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Custom Entry Category Font', 'foxiz-core' ),
				'name'     => 'category_font',
				'selector' => '{{WRAPPER}} .p-categories',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'featured_section', array(
				'label' => esc_html__( 'Featured Image', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'custom_ratio', array(
				'label'       => esc_html__( 'Custom Ratio', 'foxiz-core' ),
				'type'        => Controls_Manager::SWITCHER,
				'description' => esc_html__( 'Enable custom ratio for the featured product images.', 'foxiz-core' ),
				'default'     => false,
			)
		);
		$this->add_responsive_control(
			'display_ratio', array(
				'label'       => esc_html__( 'Ratio Percent', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => Options::display_ratio_description(),
				'selectors'   => array(
					'{{WRAPPER}}' => '--feat-ratio: {{VALUE}}%',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'sale_section', array(
				'label' => esc_html__( 'Sale Label', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'sale_color', array(
				'label'       => esc_html__( 'Sale Color', 'foxiz-core' ),
				'type'        => Controls_Manager::COLOR,
				'description' => esc_html__( 'Select a color for the sale label.', 'foxiz-core' ),
				'selectors'   => array( '{{WRAPPER}}' => '--wc-sale-color: {{VALUE}};' ),
			)
		);
		$this->add_control(
			'sale_bg', array(
				'label'       => esc_html__( 'Sale Background', 'foxiz-core' ),
				'type'        => Controls_Manager::COLOR,
				'description' => esc_html__( 'Select a background color for the sale label.', 'foxiz-core' ),
				'selectors'   => array( '{{WRAPPER}}' => '--wc-sale-bg: {{VALUE}};' ),
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Sale Font', 'foxiz-core' ),
				'name'     => 'sale_font',
				'selector' => '{{WRAPPER}} .onsale',
			)
		);
		$this->add_responsive_control(
			'sale_padding',
			array(
				'label'       => esc_html__( 'Inner Padding', 'foxiz-core' ),
				'type'        => Controls_Manager::DIMENSIONS,
				'description' => esc_html__( 'Input a custom inner padding value for the sale label.', 'foxiz-core' ),
				'selectors'   => array(
					'{{WRAPPER}} .onsale' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'entry_title_section', array(
				'label' => esc_html__( 'Product Title', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Title Font', 'foxiz-core' ),
				'name'     => 'title_font',
				'selector' => '{{WRAPPER}} .woocommerce-loop-product__title',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'entry_meta_section', array(
				'label' => esc_html__( 'Product Price', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'price_color', array(
				'label'       => esc_html__( 'Price Color', 'foxiz-core' ),
				'type'        => Controls_Manager::COLOR,
				'description' => esc_html__( 'Select a color for the price values.', 'foxiz-core' ),
				'selectors'   => array( '{{WRAPPER}}' => '--wc-price-color: {{VALUE}};' ),
			)
		);
		$this->add_control(
			'dark_price_color', array(
				'label'       => esc_html__( 'Dark Mode - Price Color', 'foxiz-core' ),
				'type'        => Controls_Manager::COLOR,
				'description' => esc_html__( 'Select a color for the price values in dark mode.', 'foxiz-core' ),
				'selectors'   => array( '[data-theme="dark"] {{WRAPPER}}' => '--wc-price-color: {{VALUE}};' ),
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Price Font', 'foxiz-core' ),
				'name'     => 'price_font',
				'selector' => '{{WRAPPER}} .price',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'add_cart_section', array(
				'label' => esc_html__( 'Add to Cart', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'cart_button_layout_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'The Visible when Hovering layout is only for the standard (none boxed) grid on the desktop.' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
			)
		);
		$this->add_control(
			'cart_button_layout',
			array(
				'label'       => esc_html__( 'Layout', 'foxiz-core' ),
				'description' => esc_html__( 'Select a layout for the add to cart button.', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'0'       => esc_html__( 'Visible when Hovering', 'foxiz-core' ),
					'visible' => esc_html__( 'Visible', 'foxiz-core' )
				),
				'default'     => '0',
			)
		);
		$this->add_control(
			'cart_button_width',
			array(
				'label'        => esc_html__( 'Style', 'foxiz-core' ),
				'description'  => esc_html__( 'Select a style for the add to cart button.', 'foxiz-core' ),
				'type'         => Controls_Manager::SELECT,
				'options'      => array(
					'inline'   => esc_html__( '- Default -', 'foxiz-core' ),
					'fw'       => esc_html__( 'Fullwidth', 'foxiz-core' ),
					'b-inline' => esc_html__( 'Inline with Border', 'foxiz-core' ),
					'b-fw'     => esc_html__( 'Fullwidth with Border', 'foxiz-core' )
				),
				'prefix_class' => 'cart-style-',
				'default'      => 'inline',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'label'    => esc_html__( 'Add to Cart Font', 'foxiz-core' ),
				'name'     => 'add_cart_font',
				'selector' => '{{WRAPPER}} .button',
			)
		);
		$this->add_control(
			'add_cart_color', array(
				'label'     => esc_html__( 'Text & Border Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array( '{{WRAPPER}}' => '--wc-add-cart-color: {{VALUE}};' ),
			)
		);
		$this->add_control(
			'add_cart_bg', array(
				'label'     => esc_html__( 'Background Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array( '{{WRAPPER}}' => '--wc-add-cart-bg: {{VALUE}}; --wc-add-cart-bg-90: {{VALUE}}e6;' ),
			)
		);
		$this->add_control(
			'dark_add_cart_color', array(
				'label'     => esc_html__( 'Dark Mode - Text & Border Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array( '[data-theme="dark"] {{WRAPPER}}' => '--wc-add-cart-color: {{VALUE}};' ),
			)
		);
		$this->add_control(
			'dark_add_cart_bg', array(
				'label'     => esc_html__( 'Dark Mode - Background Color', 'foxiz-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array( '[data-theme="dark"] {{WRAPPER}}' => '--wc-add-cart-bg: {{VALUE}}; --wc-add-cart-bg-90: {{VALUE}}e6;' ),
			)
		);
		$this->add_responsive_control(
			'add_cart_padding',
			array(
				'label'       => esc_html__( 'Button Padding', 'foxiz-core' ),
				'type'        => Controls_Manager::DIMENSIONS,
				'description' => esc_html__( 'Input a custom inner padding value for the add to cart button.', 'foxiz-core' ),
				'selectors'   => array(
					'{{WRAPPER}} .product-btn a' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				),
			)
		);
		$this->add_control(
			'add_cart_border', array(
				'label'     => esc_html__( 'Border Radius', 'foxiz-core' ),
				'type'      => Controls_Manager::NUMBER,
				'selectors' => array(
					'{{WRAPPER}}' => '--wc-add-cart-border: {{VALUE}}px;',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'box_section', array(
				'label' => esc_html__( 'Boxed', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'box_border',
			array(
				'label'       => esc_html__( 'Border Radius', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => Options::border_description(),
				'selectors'   => array(
					'{{WRAPPER}}' => '--wrap-border: {{VALUE}}px;',
				),
			)
		);
		$this->add_control(
			'box_style',
			array(
				'label'       => esc_html__( 'Box Style', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => esc_html__( 'Select a box style for the product listing.', 'foxiz-core' ),
				'options'     => Options::box_style_dropdown(),
				'default'     => '0',
			)
		);
		$this->add_responsive_control(
			'box_padding', array(
				'label'       => esc_html__( 'Box Padding', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => Options::el_spacing_description(),
				'selectors'   => array( '{{WRAPPER}}' => '--box-spacing: {{VALUE}}px;' ),
			)
		);
		$this->add_control(
			'box_color',
			array(
				'label'       => esc_html__( 'Box Color', 'foxiz-core' ),
				'type'        => Controls_Manager::COLOR,
				'description' => Options::box_color_description(),
				'selectors'   => array( '{{WRAPPER}}' => '--box-color: {{VALUE}};' ),
			)
		);
		$this->add_control(
			'dark_box_color',
			array(
				'label'       => esc_html__( 'Dark Mode - Box Color', 'foxiz-core' ),
				'type'        => Controls_Manager::COLOR,
				'description' => Options::box_dark_color_description(),
				'selectors'   => array( '{{WRAPPER}}' => '--dark-box-color: {{VALUE}};' ),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'color_section', array(
				'label' => esc_html__( 'Text Color Scheme', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'color_scheme_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => Options::color_scheme_info_description(),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
			)
		);
		$this->add_control(
			'color_scheme',
			array(
				'label'       => esc_html__( 'Text Color Scheme', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::color_scheme_description(),
				'options'     => array(
					'0' => esc_html__( 'Default (Dark Text)', 'foxiz-core' ),
					'1' => esc_html__( 'Light Text', 'foxiz-core' )
				),
				'default'     => '0',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'layout_section', array(
				'label' => esc_html__( 'Layout', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);
		$this->add_control(
			'desktop_layout',
			array(
				'label'       => esc_html__( 'Desktop Layout', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => esc_html__( 'Select a layout for the product listing on the desktop.', 'foxiz' ),
				'options'     => Options::mobile_layout_dropdown( false ),
				'default'     => 'grid'
			)
		);
		$this->add_control(
			'tablet_layout',
			array(
				'label'       => esc_html__( 'Tablet Layout', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::tablet_layout_description(),
				'options'     => Options::mobile_layout_dropdown( false ),
				'default'     => 'grid'
			)
		);
		$this->add_control(
			'mobile_layout',
			array(
				'label'       => esc_html__( 'Mobile Layout', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::mobile_layout_description(),
				'options'     => Options::mobile_layout_dropdown( false ),
				'default'     => 'grid'
			)
		);
		$this->add_responsive_control(
			'featured_list_width', array(
				'label'       => esc_html__( 'List - Image Width', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => Options::mobile_featured_width_description(),
				'placeholder' => '150',
				'selectors'   => array( '{{WRAPPER}}' => '--feat-list-width: {{VALUE}}px;' ),
			)
		);
		$this->add_control(
			'featured_list_position', array(
				'label'       => esc_html__( 'List - Image Position', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::featured_position_description(),
				'options'     => Options::featured_position_dropdown( false ),
				'default'     => 'left',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'block_columns', array(
				'label' => esc_html__( 'Columns', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);
		$this->add_control(
			'columns',
			array(
				'label'       => esc_html__( 'Columns on Desktop', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::columns_description(),
				'options'     => Options::columns_dropdown(),
				'default'     => '0',
			)
		);
		$this->add_control(
			'columns_tablet',
			array(
				'label'       => esc_html__( 'Columns on Tablet', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::columns_tablet_description(),
				'options'     => Options::columns_dropdown(),
				'default'     => '0',
			)
		);
		$this->add_control(
			'columns_mobile',
			array(
				'label'       => esc_html__( 'Columns on Mobile', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::columns_mobile_description(),
				'options'     => Options::columns_dropdown( array( 0, 1, 2 ) ),
				'default'     => '0',
			)
		);
		$this->add_control(
			'column_gap',
			array(
				'label'       => esc_html__( 'Columns Gap', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::column_gap_description(),
				'options'     => Options::column_gap_dropdown(),
				'default'     => '0',
			)
		);
		$this->add_responsive_control(
			'column_gap_custom', array(
				'label'       => esc_html__( '1/2 Custom Gap Value', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => Options::column_gap_custom_description(),
				'selectors'   => array(
					'{{WRAPPER}} .is-gap-custom'                  => 'margin-left: -{{VALUE}}px; margin-right: -{{VALUE}}px; --column-gap: {{VALUE}}px;',
					'{{WRAPPER}} .is-gap-custom .block-inner > *' => 'padding-left: {{VALUE}}px; padding-right: {{VALUE}}px;'
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'border_section', array(
				'label' => esc_html__( 'Grid Borders', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);
		$this->add_control(
			'border_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => Options::column_border_info(),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
			)
		);
		$this->add_control(
			'column_border',
			array(
				'label'       => esc_html__( 'Column Border', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::column_border_description(),
				'options'     => Options::column_border_dropdown(),
				'default'     => '0',
			)
		);
		$this->add_control(
			'bottom_border',
			array(
				'label'       => esc_html__( 'Bottom Border', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::bottom_border_description(),
				'options'     => Options::column_border_dropdown(),
				'default'     => '0',
			)
		);
		$this->add_control(
			'last_bottom_border',
			array(
				'label'       => esc_html__( 'Last Bottom Border', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::last_bottom_border_description(),
				'options'     => Options::switch_dropdown( false ),
				'default'     => '-1',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'spacing_section', array(
				'label' => esc_html__( 'Spacing', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);
		$this->add_responsive_control(
			'el_spacing', array(
				'label'       => esc_html__( 'Custom Element Spacing', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => Options::el_spacing_description(),
				'selectors'   => array( '{{WRAPPER}}' => '--el-spacing: {{VALUE}}px;' ),
			)
		);
		$this->add_responsive_control(
			'bottom_margin', array(
				'label'       => esc_html__( 'Custom Bottom Margin', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => Options::el_margin_description(),
				'selectors'   => array( '{{WRAPPER}} .block-wrap' => '--bottom-spacing: {{VALUE}}px;' ),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'center_section', array(
				'label' => esc_html__( 'Centering', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);
		$this->add_control(
			'center_mode',
			array(
				'label'       => esc_html__( 'Centering Content', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => esc_html__( 'Centering text and content for the product listing.', 'foxiz-core' ),
				'options'     => Options::switch_dropdown( false ),
				'default'     => '-1'
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'mobile_scroll_section', array(
				'label' => esc_html__( 'Tablet/Mobile Horizontal Scroll', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);
		$this->add_control(
			'horizontal_scroll',
			array(
				'label'       => esc_html__( 'Horizontal Scroll', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => Options::horizontal_scroll_description(),
				'options'     => array(
					'0' => esc_html__( '- Disable -', 'foxiz-core' ),
					'1' => esc_html__( 'Enable', 'foxiz-core' ),
				),
				'default'     => '0',
			)
		);
		$this->add_control(
			'scroll_width_tablet', array(
				'label'       => esc_html__( 'Tablet - Post Module Width', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'placeholder' => '300',
				'description' => Options::scroll_width_tablet_description(),
				'selectors'   => array( '{{WRAPPER}}' => '--tablet-scroll-width: {{VALUE}}px;' ),
			)
		);
		$this->add_control(
			'scroll_width_mobile', array(
				'label'       => esc_html__( 'Mobile - Post Module Width', 'foxiz-core' ),
				'type'        => Controls_Manager::NUMBER,
				'placeholder' => '300',
				'description' => Options::scroll_width_mobile_description(),
				'selectors'   => array( '{{WRAPPER}}' => '--mobile-scroll-width: {{VALUE}}px;' ),
			)
		);
		$this->end_controls_section();
	}

	protected function render() {

		if ( ! class_exists( 'WooCommerce' ) ) {
			return false;
		}

		if ( function_exists( 'foxiz_get_product_grid' ) ) {

			$settings         = $this->get_settings();
			$settings['uuid'] = 'uid_' . $this->get_id();
			echo \foxiz_get_product_grid( $settings );
		}
	}
}