<?php

namespace foxizElementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use foxizElementorControl\Options;

/**
 * Class
 * @package foxizElementor\Widgets
 */
class Logo extends Widget_Base {

	public function get_name() {

		return 'foxiz-logo';
	}

	public function get_title() {

		return esc_html__( 'Foxiz - Site Logo', 'foxiz-core' );
	}

	public function get_icon() {

		return 'eicon-logo';
	}

	public function get_categories() {

		return array( 'foxiz_header' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general', array(
				'label' => esc_html__( 'General', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_control(
			'logo',
			array(
				'label'       => esc_html__( 'Logo Image', 'foxiz-core' ),
				'description' => esc_html__( 'Select or upload a logo image, retina image is recommended.', 'foxiz-core' ),
				'type'        => Controls_Manager::MEDIA
			)
		);
		$this->add_control(
			'dark_logo',
			array(
				'label'       => esc_html__( 'Dark Mode - Logo Image', 'foxiz-core' ),
				'description' => esc_html__( 'Select or upload a logo image in dark mode, retina image is recommended.', 'foxiz-core' ),
				'type'        => Controls_Manager::MEDIA
			)
		);
		$this->add_control(
			'logo_link',
			array(
				'label'       => esc_html__( 'Custom Logo URL', 'foxiz-core' ),
				'description' => esc_html__( 'Input a custom URL for the logo, Default will return to the homepage.', 'foxiz-core' ),
				'type'        => Controls_Manager::URL,
				'default'     => array(
					'url'               => '',
					'is_external'       => false,
					'nofollow'          => false,
					'custom_attributes' => '',
				),
				'label_block' => true,
			)
		);
		$this->add_control(
			'heading_tag',
			array(
				'label'       => esc_html__( 'Site Title Included', 'foxiz-core' ),
				'description' => esc_html__( 'Add the site title (H1) and description (hidden mode) to optimize for SEO. This setting is for the main site logo in the home page and should only be enabled once if you added multiple logos.', 'foxiz-core' ),
				'type'        => Controls_Manager::SWITCHER,
				'default'     => 'no'
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'logo-style-section', array(
				'label' => esc_html__( 'Styles', 'foxiz-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'logo_width', array(
				'label'       => __( 'Logo Width', 'foxiz-core' ),
				'description' => esc_html__( 'Set a max width for your logo', 'foxiz-core' ),
				'type'        => Controls_Manager::SLIDER,
				'range'       => array(
					'px' => array(
						'min' => 0,
						'max' => 800,
					),
				),
				'selectors'   => array( '{{WRAPPER}} .the-logo img' => 'max-width: {{SIZE}}px; width: {{SIZE}}px' )
			)
		);
		$this->add_control(
			'sticky_logo_width', array(
				'label'       => __( 'Sticky Logo Width', 'foxiz-core' ),
				'description' => esc_html__( 'Set a max width for the logo if your logo is included in the sticky menu bar.', 'foxiz-core' ),
				'type'        => Controls_Manager::SLIDER,
				'range'       => array(
					'px' => array(
						'min' => 0,
						'max' => 800,
					),
				),
				'selectors'   => array( '.sticky-on {{WRAPPER}} .the-logo img' => 'max-width: {{SIZE}}px; width: {{SIZE}}px' )
			)
		);
		$this->add_control(
			'align', array(
				'label'     => esc_html__( 'Alignment', 'foxiz-core' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'foxiz-core' ),
						'icon'  => 'eicon-align-start-h',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'foxiz-core' ),
						'icon'  => 'eicon-align-center-h',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'foxiz-core' ),
						'icon'  => 'eicon-align-end-h',
					),
				),
				'selectors' => array( '{{WRAPPER}} .the-logo' => 'text-align: {{VALUE}};', ),
			)
		);
		$this->add_control(
			'feat_lazyload',
			array(
				'label'       => esc_html__( 'Lazy Load', 'foxiz-core' ),
				'type'        => Controls_Manager::SELECT,
				'description' => esc_html__( 'Enable or disable lazy load for the logo if you put this block inside the body or footer', 'foxiz-core' ),
				'options'     => array(
					'0' => esc_html__( '- Disable -', 'foxiz-core' ),
					'1' => esc_html__( 'Enable', 'foxiz-core' ),
				),
				'default'     => '0',
			)
		);
		$this->end_controls_section();
	}

	/**
	 * @return false
	 */
	protected function render() {

		$settings = $this->get_settings();

		if ( empty( $settings['logo']['url'] ) ) {
			return false;
		}
		$logo_width  = 1;
		$logo_height = 1;

		if ( ! empty( $settings['logo']['id'] ) ) {
			$attachment = \wp_get_attachment_image_src( $settings['logo']['id'], 'full' );
			if ( ! empty( $attachment[1] ) ) {
				$logo_width = $attachment[1];
			}
			if ( ! empty( $attachment[2] ) ) {
				$logo_height = $attachment[2];
			}
		}
		if ( empty( $settings['logo_link']['url'] ) ) {
			$settings['logo_link']['url'] = home_url( '/' );
		}
		$lazy = 'eager';
		if ( ! empty( $settings['feat_lazyload'] ) && '1' === (string) $settings['feat_lazyload'] ) {
			$lazy = 'lazy';
		}
		$this->add_link_attributes( 'logo_link', $settings['logo_link'] );
		?>
        <div class="the-logo">
            <a <?php echo $this->get_render_attribute_string( 'logo_link' ); ?>>
				<?php if ( ! empty( $settings['dark_logo']['url'] ) ) : ?>
                    <img loading="<?php echo esc_attr( $lazy ); ?>" decoding="async" data-mode="default" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" src="<?php echo $settings['logo']['url']; ?>" alt="<?php echo ( ! empty( $settings['logo']['alt'] ) ) ? esc_attr( $settings['logo']['alt'] ) : get_bloginfo( 'name' ); ?>">
                    <img loading="<?php echo esc_attr( $lazy ); ?>" decoding="async" data-mode="dark" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" src="<?php echo $settings['dark_logo']['url']; ?>" alt="<?php echo ( ! empty( $settings['dark_logo']['alt'] ) ) ? esc_attr( $settings['dark_logo']['alt'] ) : ''; ?>">
				<?php else : ?>
                    <img loading="<?php echo esc_attr( $lazy ); ?>" decoding="async" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" src="<?php echo $settings['logo']['url']; ?>" alt="<?php echo ( ! empty( $settings['logo']['alt'] ) ) ? esc_attr( $settings['logo']['alt'] ) : get_bloginfo( 'name' ); ?>">
				<?php endif; ?>
            </a>
			<?php if ( is_front_page() && ! empty( $settings['heading_tag'] ) ) : ?>
                <h1 class="logo-title hidden"><?php bloginfo( 'name' ); ?></h1>
				<?php if ( get_bloginfo( 'description' ) ) : ?>
                    <p class="site-description hidden"><?php bloginfo( 'description' ); ?></p>
				<?php endif;
			endif; ?>
        </div>
		<?php
	}
}